/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

public class ModelTestOperationValidatorFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean validateNone;
    private final List<OperationEntry> entries;

    private ModelTestOperationValidatorFilter(List<OperationEntry> entries) {
        this.entries = entries;
        this.validateNone = false;
    }

    private ModelTestOperationValidatorFilter(boolean validateNone) {
        this.validateNone = validateNone;
        this.entries = null;
    }

    public static ModelTestOperationValidatorFilter createValidateNone() {
        return new ModelTestOperationValidatorFilter(true);
    }

    public static ModelTestOperationValidatorFilter createValidateAll() {
        return new ModelTestOperationValidatorFilter(false);
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public ModelNode adjustForValidation(ModelNode op) {
        if (this.validateNone) {
            return null;
        }
        if (this.entries == null) {
            return op;
        }
        ModelNode addr = op.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)addr);
        String name = op.get("operation").asString();
        for (OperationEntry entry : this.entries) {
            if (!this.nameMatch(name, entry) || entry.address.size() != address.size()) continue;
            for (int i = 0; i < address.size(); ++i) {
                if (!this.pathElementMatch(address.getElement(i), entry.address.getElement(i))) continue;
                if (entry.action == Action.NOCHECK) {
                    return null;
                }
                return op.resolve();
            }
        }
        return op;
    }

    private boolean nameMatch(String opName, OperationEntry entry) {
        if (entry.name.equals("*")) {
            return true;
        }
        return opName.equals(entry.name);
    }

    private boolean pathElementMatch(PathElement element, PathElement operationEntryElement) {
        if (!operationEntryElement.getKey().equals("*") && !operationEntryElement.getKey().equals(element.getKey())) {
            return false;
        }
        if (operationEntryElement.getValue().equals("*")) {
            return true;
        }
        return operationEntryElement.getValue().equals(element.getValue());
    }

    public static void main(String[] args) {
        System.out.println(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"*", (String)"*"), PathElement.pathElement((String)"x", (String)"*")}));
    }

    public static enum Action {
        NOCHECK,
        RESOLVE;

    }

    public static class OperationEntry
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private volatile PathAddress address;
        private volatile String name;
        private volatile Action action;

        public OperationEntry(PathAddress address, String name, Action action) {
            this.address = address;
            this.name = name;
            this.action = action;
        }

        public OperationEntry() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
            out.writeObject(this.address.toModelNode());
            out.writeObject((Object)this.action);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.address = PathAddress.pathAddress((ModelNode)((ModelNode)in.readObject()));
            this.action = (Action)((Object)in.readObject());
        }
    }

    public static class Builder {
        List<OperationEntry> entries = new ArrayList<OperationEntry>();

        private Builder() {
        }

        public Builder addOperation(PathAddress pathAddress, String name, Action action) {
            this.entries.add(new OperationEntry(pathAddress, name, action));
            return this;
        }

        public ModelTestOperationValidatorFilter build() {
            return new ModelTestOperationValidatorFilter(this.entries);
        }
    }
}

