/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersLogger;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;
import org.junit.Assert;

public abstract class ModelTestKernelServicesImpl<T extends ModelTestKernelServices<T>>
implements ModelTestKernelServices<T> {
    private volatile ServiceContainer container;
    private final ModelTestModelControllerService controllerService;
    private final ModelController controller;
    private final StringConfigurationPersister persister;
    private final OperationValidator operationValidator;
    private final ManagementResourceRegistration rootRegistration;
    private final Map<ModelVersion, T> legacyServices;
    private final boolean successfulBoot;
    private final Throwable bootError;

    protected ModelTestKernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError) {
        this.container = container;
        this.controllerService = controllerService;
        this.controller = controllerService.getValue();
        this.persister = persister;
        this.operationValidator = operationValidator;
        this.rootRegistration = rootRegistration;
        this.legacyServices = legacyModelVersion != null ? null : new HashMap();
        this.successfulBoot = successfulBoot;
        this.bootError = bootError;
    }

    @Override
    public boolean isSuccessfulBoot() {
        return this.successfulBoot;
    }

    @Override
    public Throwable getBootError() {
        return this.bootError;
    }

    @Override
    public T getLegacyServices(ModelVersion modelVersion) {
        this.checkIsMainController();
        ModelTestKernelServices legacy = (ModelTestKernelServices)this.legacyServices.get(modelVersion);
        if (legacy == null) {
            throw new IllegalStateException("No legacy subsystem controller was found for model version " + modelVersion);
        }
        return (T)legacy;
    }

    protected void checkIsMainController() {
        if (this.legacyServices == null) {
            throw new IllegalStateException("Can only be called for the main controller");
        }
    }

    @Override
    public ModelNode readWholeModel() {
        return this.readWholeModel(false);
    }

    @Override
    public ModelNode readWholeModel(boolean includeAliases) {
        return this.readWholeModel(includeAliases, false);
    }

    @Override
    public ModelNode readWholeModel(boolean includeAliases, boolean includeRuntime) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        if (includeRuntime) {
            op.get("include-runtime").set(true);
        }
        if (includeAliases) {
            op.get("include-aliases").set(true);
        }
        ModelNode result = this.executeOperation(op, new InputStream[0]);
        return ModelTestUtils.checkResultAndGetContents(result);
    }

    @Override
    public ServiceContainer getContainer() {
        return this.container;
    }

    @Override
    public ModelNode executeOperation(ModelNode operation, InputStream ... inputStreams) {
        if (inputStreams.length == 0) {
            return this.executeOperation(operation, ModelController.OperationTransactionControl.COMMIT);
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            ModelControllerClient client = this.controller.createClient((Executor)executor);
            OperationBuilder builder = OperationBuilder.create((ModelNode)operation);
            for (InputStream in : inputStreams) {
                builder.addInputStream(in);
            }
            Operation op = builder.build();
            try {
                ModelNode len$ = client.execute(op);
                return len$;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    public ModelNode executeOperation(ModelNode operation, ModelController.OperationTransactionControl txControl) {
        return this.controller.execute(operation, null, txControl, null);
    }

    @Override
    public ModelNode executeForResult(ModelNode operation, InputStream ... inputStreams) throws OperationFailedException {
        ModelNode rsp = this.executeOperation(operation, inputStreams);
        if ("failed".equals(rsp.get("outcome").asString())) {
            throw new OperationFailedException(rsp.get("failure-description"));
        }
        return rsp.get("result");
    }

    @Override
    public void executeForFailure(ModelNode operation, InputStream ... inputStreams) {
        try {
            this.executeForResult(operation, inputStreams);
            Assert.fail((String)"Should have given error");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    @Override
    public String getPersistedSubsystemXml() {
        return this.persister.getMarshalled();
    }

    @Override
    public void validateOperations(List<ModelNode> operations) {
        this.operationValidator.validateOperations(operations);
    }

    @Override
    public void validateOperation(ModelNode operation) {
        this.operationValidator.validateOperation(operation);
    }

    @Override
    public void shutdown() {
        if (this.container != null) {
            this.container.shutdown();
            try {
                this.container.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.container = null;
            if (this.legacyServices != null) {
                for (ModelTestKernelServices legacyService : this.legacyServices.values()) {
                    legacyService.shutdown();
                }
            }
        }
    }

    @Override
    public ImmutableManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }

    protected void addLegacyKernelService(ModelVersion modelVersion, T legacyServices) {
        this.legacyServices.put(modelVersion, legacyServices);
    }

    protected ModelNode internalExecute(ModelNode operation, OperationStepHandler handler) {
        return this.controllerService.internalExecute(operation, OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, null, handler);
    }

    protected TransformationContext createTransformationContext(TransformationTarget target) {
        return new TestTransformationContext(target, ModelTestModelControllerService.grabRootResource(this));
    }

    protected TransformerRegistry getTransformersRegistry() {
        return this.controllerService.getTransformersRegistry();
    }

    private class TestTransformationContext
    implements TransformationContext {
        private final TransformationTarget target;
        private final Resource rootResource;

        TestTransformationContext(TransformationTarget target, Resource rootResource) {
            this.target = target;
            this.rootResource = rootResource;
        }

        public TransformationTarget getTarget() {
            return this.target;
        }

        public ProcessType getProcessType() {
            return ModelTestKernelServicesImpl.this.controllerService.getProcessType();
        }

        public RunningMode getRunningMode() {
            return ModelTestKernelServicesImpl.this.controllerService.getRunningMode();
        }

        public ImmutableManagementResourceRegistration getResourceRegistration(PathAddress address) {
            return ModelTestKernelServicesImpl.this.controllerService.getRootRegistration().getSubModel(address);
        }

        public ImmutableManagementResourceRegistration getResourceRegistrationFromRoot(PathAddress address) {
            return ModelTestKernelServicesImpl.this.controllerService.getRootRegistration().getSubModel(address);
        }

        public Resource readResource(PathAddress address) {
            return Resource.Tools.navigate((Resource)this.rootResource, (PathAddress)address);
        }

        public Resource readResourceFromRoot(PathAddress address) {
            return Resource.Tools.navigate((Resource)this.rootResource, (PathAddress)address);
        }

        public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
            return node.resolve();
        }

        public TransformersLogger getLogger() {
            return TransformersLogger.getLogger((TransformationTarget)this.getTarget());
        }

        public boolean isSkipRuntimeIgnoreCheck() {
            return false;
        }
    }
}

