/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.sonatype.aether.AbstractRepositoryListener;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.connector.file.FileRepositoryConnectorFactory;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.transfer.TransferResource;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;

class MavenUtil {
    private static final RepositorySystem REPOSITORY_SYSTEM = MavenUtil.newRepositorySystem();
    private static final String AETHER_API_NAME = File.separatorChar == '/' ? "/org/sonatype/aether/aether-api/" : "\\org\\sonatype\\aether\\aether-api\\";
    private static String mavenRepository;

    MavenUtil() {
    }

    static URL createMavenGavURL(String artifactGav) throws MalformedURLException {
        DefaultArtifact artifact = new DefaultArtifact(artifactGav);
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Null version");
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionScheme.parseVersion(artifact.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            versionScheme.parseVersionRange(artifact.getVersion());
            throw new IllegalArgumentException(artifact.getVersion() + " is a version range. A specific version is needed");
        }
        catch (InvalidVersionSpecificationException expected) {
            ArtifactResult artifactResult;
            RepositorySystemSession session = MavenUtil.newRepositorySystemSession();
            List<RemoteRepository> remoteRepositories = MavenUtil.createRemoteRepositories();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            for (RemoteRepository remoteRepo : remoteRepositories) {
                artifactRequest.addRepository(remoteRepo);
            }
            try {
                artifactResult = REPOSITORY_SYSTEM.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException(e);
            }
            File file = artifactResult.getArtifact().getFile().getAbsoluteFile();
            System.out.println(file);
            return file.toURI().toURL();
        }
    }

    static List<URL> createMavenGavRecursiveURLs(String artifactGav, String ... excludes) throws MalformedURLException, DependencyCollectionException, DependencyResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(artifactGav);
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Null version");
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionScheme.parseVersion(artifact.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            versionScheme.parseVersionRange(artifact.getVersion());
            throw new IllegalArgumentException(artifact.getVersion() + " is a version range. A specific version is needed");
        }
        catch (InvalidVersionSpecificationException expected) {
            ArtifactResult artifactResult;
            RepositorySystemSession session = MavenUtil.newRepositorySystemSession();
            List<RemoteRepository> remoteRepositories = MavenUtil.createRemoteRepositories();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            for (RemoteRepository remoteRepo : remoteRepositories) {
                artifactRequest.addRepository(remoteRepo);
            }
            try {
                artifactResult = REPOSITORY_SYSTEM.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException(e);
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(MavenUtil.artifactToUrl(artifactResult.getArtifact()));
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)artifact, "compile"));
            for (RemoteRepository remoteRepo : remoteRepositories) {
                collectRequest.addRepository(remoteRepo);
            }
            DependencyNode node = REPOSITORY_SYSTEM.collectDependencies(session, collectRequest).getRoot();
            ExclusionsDependencyFilter filter = new ExclusionsDependencyFilter(Arrays.asList(excludes));
            DependencyRequest dependencyRequest = new DependencyRequest(node, (DependencyFilter)filter);
            REPOSITORY_SYSTEM.resolveDependencies(session, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (Artifact cur : nlg.getArtifacts(false)) {
                urls.add(MavenUtil.artifactToUrl(cur));
            }
            System.out.println("--------------------");
            System.out.println(nlg.getClassPath());
            System.out.println("--------------------");
            return urls;
        }
    }

    private static List<RemoteRepository> createRemoteRepositories() {
        String remoteReposFromSysProp = System.getProperty("org.jboss.model.test.maven.repository.urls");
        if (remoteReposFromSysProp == null || remoteReposFromSysProp.trim().length() == 0) {
            return Collections.singletonList(new RemoteRepository("jboss-developer", "default", "http://repository.jboss.org/nexus/content/groups/developer/"));
        }
        int i = 0;
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (String repoUrl : remoteReposFromSysProp.split(",")) {
            remoteRepositories.add(new RemoteRepository("repo" + i, "default", repoUrl.trim()));
            ++i;
        }
        return remoteRepositories;
    }

    private static RepositorySystemSession newRepositorySystemSession() {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(MavenUtil.determineLocalMavenRepositoryHack());
        session.setLocalRepositoryManager(REPOSITORY_SYSTEM.newLocalRepositoryManager(localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    private static String determineLocalMavenRepositoryHack() {
        if (mavenRepository == null) {
            String localRepositoryRoot;
            String classPath = System.getProperty("java.class.path");
            int end = classPath.indexOf(AETHER_API_NAME) + 1;
            int start = classPath.lastIndexOf(File.pathSeparatorChar, end) + 1;
            mavenRepository = localRepositoryRoot = classPath.substring(start, end);
        }
        return mavenRepository;
    }

    private static URL artifactToUrl(Artifact artifact) throws MalformedURLException {
        return artifact.getFile().toURI().toURL();
    }

    public static RepositorySystem newRepositorySystem() {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static class ConsoleTransferListener
    extends AbstractTransferListener {
        private PrintStream out;
        private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
        private int lastLength;

        public ConsoleTransferListener() {
            this(null);
        }

        public ConsoleTransferListener(PrintStream out) {
            this.out = out != null ? out : System.out;
        }

        public void transferInitiated(TransferEvent event) {
            String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
            this.out.println(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
        }

        public void transferProgressed(TransferEvent event) {
            TransferResource resource = event.getResource();
            this.downloads.put(resource, event.getTransferredBytes());
            StringBuilder buffer = new StringBuilder(64);
            for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
                long total = entry.getKey().getContentLength();
                long complete = entry.getValue();
                buffer.append(this.getStatus(complete, total)).append("  ");
            }
            int pad = this.lastLength - buffer.length();
            this.lastLength = buffer.length();
            this.pad(buffer, pad);
            buffer.append('\r');
            this.out.print(buffer);
        }

        private String getStatus(long complete, long total) {
            if (total >= 1024L) {
                return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
            }
            if (total >= 0L) {
                return complete + "/" + total + " B ";
            }
            if (complete >= 1024L) {
                return this.toKB(complete) + " KB ";
            }
            return complete + " B ";
        }

        private void pad(StringBuilder buffer, int spaces) {
            String block = "                                        ";
            while (spaces > 0) {
                int n = Math.min(spaces, block.length());
                buffer.append(block, 0, n);
                spaces -= n;
            }
        }

        public void transferSucceeded(TransferEvent event) {
            this.transferCompleted(event);
            TransferResource resource = event.getResource();
            long contentLength = event.getTransferredBytes();
            if (contentLength >= 0L) {
                String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
                String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
                String throughput = "";
                long duration = System.currentTimeMillis() - resource.getTransferStartTime();
                if (duration > 0L) {
                    DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                    double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                    throughput = " at " + format.format(kbPerSec) + " KB/sec";
                }
                this.out.println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
            }
        }

        public void transferFailed(TransferEvent event) {
            this.transferCompleted(event);
            event.getException().printStackTrace(this.out);
        }

        private void transferCompleted(TransferEvent event) {
            this.downloads.remove(event.getResource());
            StringBuilder buffer = new StringBuilder(64);
            this.pad(buffer, this.lastLength);
            buffer.append('\r');
            this.out.print(buffer);
        }

        public void transferCorrupted(TransferEvent event) {
            event.getException().printStackTrace(this.out);
        }

        protected long toKB(long bytes) {
            return (bytes + 1023L) / 1024L;
        }
    }

    private static class ConsoleRepositoryListener
    extends AbstractRepositoryListener {
        private PrintStream out;

        public ConsoleRepositoryListener() {
            this(null);
        }

        public ConsoleRepositoryListener(PrintStream out) {
            this.out = out != null ? out : System.out;
        }

        public void artifactDeployed(RepositoryEvent event) {
            this.out.println("Deployed " + event.getArtifact() + " to " + event.getRepository());
        }

        public void artifactDeploying(RepositoryEvent event) {
            this.out.println("Deploying " + event.getArtifact() + " to " + event.getRepository());
        }

        public void artifactDescriptorInvalid(RepositoryEvent event) {
            this.out.println("Invalid artifact descriptor for " + event.getArtifact() + ": " + event.getException().getMessage());
        }

        public void artifactDescriptorMissing(RepositoryEvent event) {
            this.out.println("Missing artifact descriptor for " + event.getArtifact());
        }

        public void artifactInstalled(RepositoryEvent event) {
            this.out.println("Installed " + event.getArtifact() + " to " + event.getFile());
        }

        public void artifactInstalling(RepositoryEvent event) {
            this.out.println("Installing " + event.getArtifact() + " to " + event.getFile());
        }

        public void artifactResolved(RepositoryEvent event) {
            this.out.println("Resolved artifact " + event.getArtifact() + " from " + event.getRepository());
        }

        public void artifactDownloading(RepositoryEvent event) {
            this.out.println("Downloading artifact " + event.getArtifact() + " from " + event.getRepository());
        }

        public void artifactDownloaded(RepositoryEvent event) {
            this.out.println("Downloaded artifact " + event.getArtifact() + " from " + event.getRepository());
        }

        public void artifactResolving(RepositoryEvent event) {
            this.out.println("Resolving artifact " + event.getArtifact());
        }

        public void metadataDeployed(RepositoryEvent event) {
            this.out.println("Deployed " + event.getMetadata() + " to " + event.getRepository());
        }

        public void metadataDeploying(RepositoryEvent event) {
            this.out.println("Deploying " + event.getMetadata() + " to " + event.getRepository());
        }

        public void metadataInstalled(RepositoryEvent event) {
            this.out.println("Installed " + event.getMetadata() + " to " + event.getFile());
        }

        public void metadataInstalling(RepositoryEvent event) {
            this.out.println("Installing " + event.getMetadata() + " to " + event.getFile());
        }

        public void metadataInvalid(RepositoryEvent event) {
            this.out.println("Invalid metadata " + event.getMetadata());
        }

        public void metadataResolved(RepositoryEvent event) {
            this.out.println("Resolved metadata " + event.getMetadata() + " from " + event.getRepository());
        }

        public void metadataResolving(RepositoryEvent event) {
            this.out.println("Resolving metadata " + event.getMetadata() + " from " + event.getRepository());
        }
    }

    private static class ManualWagonProvider
    implements WagonProvider {
        private ManualWagonProvider() {
        }

        public Wagon lookup(String roleHint) throws Exception {
            if ("http".equals(roleHint)) {
                DefaultPlexusContainer container = new DefaultPlexusContainer();
                Wagon httpWagon = (Wagon)container.lookup(Wagon.ROLE, "http");
                container.dispose();
                return httpWagon;
            }
            return null;
        }

        public void release(Wagon wagon) {
        }
    }
}

