/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.openapi.host;

import io.smallrye.openapi.api.OpenApiConfig;
import io.undertow.server.HttpHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.Host;
import org.wildfly.microprofile.openapi.OpenAPIModelConfiguration;
import org.wildfly.microprofile.openapi.OpenAPIModelProvider;
import org.wildfly.microprofile.openapi.host.OpenAPIHttpHandler;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class OpenAPIHttpHandlerServiceInstaller
implements ServiceInstaller {
    private final OpenAPIModelConfiguration configuration;

    public OpenAPIHttpHandlerServiceInstaller(OpenAPIModelConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        String serverName = this.configuration.getServerName();
        String hostName = this.configuration.getHostName();
        String modelName = this.configuration.getModelName();
        final String path = this.configuration.getPath();
        final OpenApiConfig configuration = this.configuration.getOpenApiConfig();
        final ServiceDependency host = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName);
        final ServiceDependency provider = ServiceDependency.on((TernaryServiceDescriptor)OpenAPIModelProvider.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName, (String)modelName);
        Supplier<HttpHandler> factory = new Supplier<HttpHandler>(){

            @Override
            public HttpHandler get() {
                return new OpenAPIHttpHandler(() -> ((OpenAPIModelProvider)provider.get()).getModel(), configuration);
            }
        };
        Consumer<HttpHandler> start = new Consumer<HttpHandler>(){

            @Override
            public void accept(HttpHandler handler) {
                ((Host)host.get()).registerHandler(path, handler);
            }
        };
        Consumer<HttpHandler> stop = new Consumer<HttpHandler>(){

            @Override
            public void accept(HttpHandler handler) {
                ((Host)host.get()).unregisterHandler(path);
            }
        };
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).startWhen(Installer.StartWhen.AVAILABLE)).requires(List.of(host, provider))).onStart((Consumer)start)).onStop((Consumer)stop)).build()).install((ServiceTarget)target);
    }
}

