/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.openapi.host;

import io.smallrye.openapi.spi.OASFactoryResolverImpl;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HostServiceInstallerProvider;
import org.wildfly.microprofile.openapi.OpenAPIModelProvider;
import org.wildfly.microprofile.openapi.host.HostOpenAPIModelConfiguration;
import org.wildfly.microprofile.openapi.host.HostOpenAPIProviderServiceInstaller;
import org.wildfly.microprofile.openapi.host.OpenAPIHttpHandlerServiceInstaller;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class OpenAPIHostServiceInstallerProvider
implements HostServiceInstallerProvider {
    private static final Predicate<RuntimeCapability> HOST_FILTER = capability -> capability.getName().equals(Host.SERVICE_DESCRIPTOR.getName());

    public ResourceServiceInstaller getServiceInstaller(final String serverName, final String hostName) {
        return new ResourceServiceInstaller(){

            public Consumer<OperationContext> install(OperationContext context) {
                HostOpenAPIModelConfiguration configuration;
                ArrayList<Object> installers = new ArrayList<Object>(2);
                RuntimeCapability hostCapability = context.getResourceRegistration().getCapabilities().stream().filter(HOST_FILTER).findFirst().orElse(null);
                if (hostCapability != null && context.hasOptionalCapability(OpenAPIModelProvider.SUBSYSTEM_SERVICE_DESCRIPTOR, hostCapability, null) && (configuration = new HostOpenAPIModelConfiguration(serverName, hostName)).isEnabled()) {
                    installers.add(new HostOpenAPIProviderServiceInstaller(configuration));
                    installers.add(new OpenAPIHttpHandlerServiceInstaller(configuration));
                }
                return ResourceServiceInstaller.combine(installers).install(context);
            }
        };
    }

    static {
        OASFactoryResolver.setInstance((OASFactoryResolver)new OASFactoryResolverImpl());
    }
}

