/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.micrometer.MicrometerDependencyProcessor;
import org.wildfly.extension.micrometer.MicrometerDeploymentProcessor;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerService;
import org.wildfly.extension.micrometer.WildFlyMicrometerConfig;
import org.wildfly.extension.micrometer.otlp.OtlpRegistryDefinitionRegistrar;
import org.wildfly.extension.micrometer.prometheus.PrometheusRegistryDefinitionRegistrar;
import org.wildfly.extension.micrometer.registry.WildFlyCompositeRegistry;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeTranslation;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class MicrometerSubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    private static final String MICROMETER_MODULE = "org.wildfly.extension.micrometer";
    private static final String MICROMETER_API_MODULE = "org.wildfly.micrometer.deployment";
    private static final String CAPABILITY_NAME_METRICS = "org.wildfly.extension.metrics.scan";
    private static final String CAPABILITY_NAME_OPENTELEMETRY = "org.wildfly.extension.opentelemetry";
    public static final PathElement SUBSYSTEM_PATH = SubsystemResourceDefinitionRegistrar.pathElement((String)"micrometer");
    public static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("micrometer", MicrometerSubsystemRegistrar.class);
    public static final ServiceName MICROMETER_SERVICE_SERVICE_NAME = ServiceNameFactory.parseServiceName((String)"org.wildfly.extension.micrometer.service");
    static final NullaryServiceDescriptor<MicrometerService> SERVICE_DESCRIPTOR = NullaryServiceDescriptor.of((String)MICROMETER_SERVICE_SERVICE_NAME.getCanonicalName(), MicrometerService.class);
    static final String[] EXPORTED_MODULES = new String[]{"org.wildfly.micrometer.deployment", "io.opentelemetry.otlp", "io.micrometer"};
    public static final SimpleAttributeDefinition ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"endpoint", (ModelType)ModelType.STRING).setAttributeGroup("otlp-registry")).setRequired(false)).addFlag(AttributeAccess.Flag.ALIAS)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STEP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"step", (ModelType)ModelType.LONG, (boolean)true).setAttributeGroup("otlp-registry")).setDefaultValue(new ModelNode(60L))).setMeasurementUnit(MeasurementUnit.SECONDS)).addFlag(AttributeAccess.Flag.ALIAS)).setAllowExpression(true)).setRestartAllServices()).build();
    static final StringListAttributeDefinition EXPOSED_SUBSYSTEMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("exposed-subsystems").setDefaultValue(ModelNode.fromJSONString((String)"[\"*\"]"))).setRequired(false)).setRestartAllServices()).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(EXPOSED_SUBSYSTEMS);
    private final WildFlyCompositeRegistry compositeRegistry = new WildFlyCompositeRegistry();

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)SUBSYSTEM_PATH), (ResourceDescriptionResolver)RESOLVER).build());
        UnaryOperator translator = pathElements -> pathElements.append(new PathElement[]{OtlpRegistryDefinitionRegistrar.PATH});
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).addAttributes(ATTRIBUTES)).translateAttribute((AttributeDefinition)ENDPOINT, (AttributeTranslation)new OtlpAttributeTranslation((AttributeDefinition)ENDPOINT, translator))).translateAttribute((AttributeDefinition)STEP, (AttributeTranslation)new OtlpAttributeTranslation((AttributeDefinition)STEP, translator))).withOperationTransformation("add", (UnaryOperator)new TranslateOtlpHandler())).withDeploymentChainContributor(target -> {
            target.addDeploymentProcessor("micrometer", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new MicrometerDependencyProcessor());
            target.addDeploymentProcessor("micrometer", Phase.POST_MODULE, 14166, (DeploymentUnitProcessor)new MicrometerDeploymentProcessor());
        })).withAddOperationRestartFlag(OperationEntry.Flag.RESTART_ALL_SERVICES)).withRemoveOperationRestartFlag(OperationEntry.Flag.RESTART_ALL_SERVICES)).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new OtlpRegistryDefinitionRegistrar(this.compositeRegistry).register(registration, context);
        new PrometheusRegistryDefinitionRegistrar(this.compositeRegistry).register(registration, context);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ArrayList<String> otherMetrics = new ArrayList<String>();
        if (context.getCapabilityServiceSupport().hasCapability(CAPABILITY_NAME_METRICS)) {
            otherMetrics.add("WildFly Metrics");
        }
        if (context.getCapabilityServiceSupport().hasCapability(CAPABILITY_NAME_OPENTELEMETRY)) {
            otherMetrics.add("OpenTelemetry Metrics");
        }
        if (!otherMetrics.isEmpty() && Boolean.parseBoolean(System.getProperty("wildfly.multiple.metrics.warn", "true"))) {
            MicrometerExtensionLogger.MICROMETER_LOGGER.multipleMetricsSystemsEnabled(String.join((CharSequence)",", otherMetrics));
        }
        WildFlyMicrometerConfig micrometerConfig = new WildFlyMicrometerConfig.Builder().exposedSubsystems(EXPOSED_SUBSYSTEMS.unwrap((ExpressionResolver)context, model)).build();
        ServiceDependency mccf = ServiceDependency.on((NullaryServiceDescriptor)ModelControllerClientFactory.SERVICE_DESCRIPTOR);
        ServiceDependency executor = ServiceDependency.on((NullaryServiceDescriptor)Capabilities.MANAGEMENT_EXECUTOR);
        ServiceDependency processStateNotifier = ServiceDependency.on((NullaryServiceDescriptor)ProcessStateNotifier.SERVICE_DESCRIPTOR);
        Supplier<MicrometerService> serviceSupplier = () -> new MicrometerService.Builder().micrometerConfig(micrometerConfig).modelControllerClient(((ModelControllerClientFactory)mccf.get()).createClient((Executor)executor.get())).processStateNotifier((ProcessStateNotifier)processStateNotifier.get()).micrometerRegistry(this.compositeRegistry).build();
        AtomicReference captor = new AtomicReference();
        context.addStep((operationContext, modelNode) -> {
            MicrometerService service = (MicrometerService)captor.get();
            if (service != null) {
                service.collectResourceMetrics(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), context.getRootResourceRegistration(), Function.identity());
            }
        }, OperationContext.Stage.VERIFY);
        return (ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(serviceSupplier).provides(MICROMETER_SERVICE_SERVICE_NAME)).requires(List.of(mccf, executor, processStateNotifier))).onStart(MicrometerService::start)).onStop(Functions.closingConsumer())).withCaptor(captor::set)).startWhen(Installer.StartWhen.INSTALLED)).build();
    }

    static class OtlpAttributeTranslation
    implements AttributeTranslation {
        private final AttributeTranslation translation;

        OtlpAttributeTranslation(AttributeDefinition attribute, UnaryOperator<PathAddress> addressTranslator) {
            this.translation = AttributeTranslation.relocate((AttributeDefinition)attribute, addressTranslator);
        }

        public AttributeDefinition getTargetAttribute() {
            return this.translation.getTargetAttribute();
        }

        public UnaryOperator<PathAddress> getPathAddressTranslator() {
            return this.translation.getPathAddressTranslator();
        }

        public AttributeTranslation.AttributeValueTranslator getReadAttributeOperationTranslator() {
            return this.translation.getReadAttributeOperationTranslator();
        }

        public AttributeTranslation.AttributeValueTranslator getWriteAttributeOperationTranslator() {
            final AttributeTranslation.AttributeValueTranslator valueTranslator = this.translation.getWriteAttributeOperationTranslator();
            final UnaryOperator addressTranslator = this.translation.getPathAddressTranslator();
            return new AttributeTranslation.AttributeValueTranslator(){

                public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                    PathAddress destinationAddress = (PathAddress)addressTranslator.apply(context.getCurrentAddress());
                    try {
                        context.readResourceFromRoot(destinationAddress, false);
                    }
                    catch (Resource.NoSuchResourceException e) {
                        context.addStep(Util.createAddOperation((PathAddress)destinationAddress), context.getRootResourceRegistration().getOperationEntry(destinationAddress, "add").getOperationHandler(), OperationContext.Stage.MODEL, true);
                    }
                    return valueTranslator.translate(context, value);
                }
            };
        }
    }

    private static class TranslateOtlpHandler
    implements UnaryOperator<OperationStepHandler> {
        private TranslateOtlpHandler() {
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                ModelNode endpoint = operation.remove(ENDPOINT.getName());
                ModelNode step = operation.remove(STEP.getName());
                TreeMap<String, ModelNode> parameters = new TreeMap<String, ModelNode>();
                if (endpoint != null) {
                    parameters.put(OtlpRegistryDefinitionRegistrar.ENDPOINT.getName(), endpoint);
                }
                if (step != null) {
                    parameters.put(OtlpRegistryDefinitionRegistrar.STEP.getName(), step);
                }
                if (!parameters.isEmpty()) {
                    ModelNode otlpOperation = Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{OtlpRegistryDefinitionRegistrar.PATH}), parameters);
                    context.addStep(otlpOperation, context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{OtlpRegistryDefinitionRegistrar.PATH}), "add").getOperationHandler(), OperationContext.Stage.MODEL, true);
                }
                handler.execute(context, operation);
            };
        }
    }
}

