/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import javax.jms.Queue;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.BinderServiceUtil;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JMSQueueAdd
extends AbstractAddStepHandler {
    public static final JMSQueueAdd INSTANCE = new JMSQueueAdd(JMSQueueDefinition.ATTRIBUTES);

    private JMSQueueAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String[] jndiBindings;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ModelNode selectorNode = CommonAttributes.SELECTOR.resolveModelAttribute(context, model);
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        String selector = selectorNode.isDefined() ? selectorNode.asString() : null;
        Service<Queue> queueService = JMSQueueService.installService(name, serviceTarget, hqServiceName, selector, durable, new String[0]);
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        for (String jndiBinding : jndiBindings = JMSServices.getJndiBindings(entries)) {
            BinderServiceUtil.installBinderService(serviceTarget, jndiBinding, queueService);
        }
    }

    @Deprecated
    public void installServices(String name, ServiceTarget serviceTarget, ServiceName hqServiceName, String selector, boolean durable, String[] jndiBindings) {
        JMSQueueService.installService(name, serviceTarget, hqServiceName, selector, durable, jndiBindings);
    }
}

