/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ConnectionFactoryRemove
extends AbstractRemoveStepHandler {
    public static final ConnectionFactoryRemove INSTANCE = new ConnectionFactoryRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        context.removeService(JMSServices.getConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name}));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        JMSServerControl control = (JMSServerControl)JMSServerControl.class.cast(hqServer.getManagementService().getResource("jms.server"));
        if (control != null) {
            try {
                control.destroyConnectionFactory(name);
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

