/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class MessagingPathHandlers {
    static final String DEFAULT_RELATIVE_TO = "jboss.server.data.dir";
    private static final SimpleAttributeDefinition PATH_BASE = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PathResourceDefinition.PATH).setAllowExpression(true).setAllowNull(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition RELATIVE_TO = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PathResourceDefinition.RELATIVE_TO).setDefaultValue(new ModelNode("jboss.server.data.dir")).setAllowNull(true).setRestartAllServices().build();
    public static final Map<String, SimpleAttributeDefinition> PATHS = new HashMap<String, SimpleAttributeDefinition>();
    private static final String DEFAULT_PATH = "messaging";
    static final String DEFAULT_BINDINGS_DIR = "messagingbindings";
    static final String DEFAULT_JOURNAL_DIR = "messagingjournal";
    static final String DEFAULT_LARGE_MESSAGE_DIR = "messaginglargemessages";
    static final String DEFAULT_PAGING_DIR = "messagingpaging";
    static final OperationStepHandler PATH_ADD;
    static final OperationStepHandler PATH_REMOVE;

    static final AttributeDefinition[] getAttributes(String path) {
        return new AttributeDefinition[]{(AttributeDefinition)PATHS.get(path), RELATIVE_TO};
    }

    static void register(ManagementResourceRegistration registration, String path) {
        registration.registerOperationHandler("add", PATH_ADD, (DescriptionProvider)new MessagingSubsystemProviders.PathAddProvider(path));
        registration.registerOperationHandler("remove", PATH_REMOVE, MessagingSubsystemProviders.PATH_REMOVE);
        AttributeDefinition[] attributes = MessagingPathHandlers.getAttributes(path);
        ReloadRequiredWriteAttributeHandler attributeHandler = new ReloadRequiredWriteAttributeHandler(attributes);
        for (AttributeDefinition attribute : attributes) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)attributeHandler);
        }
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    OperationContext.RollbackHandler rh;
                    ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceController controller = context.getServiceRegistry(false).getService(hqServiceName);
                    if (controller != null) {
                        context.reloadRequired();
                        rh = OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER;
                    } else {
                        rh = OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
                    }
                    context.completeStep(rh);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static {
        PATHS.put("bindings-directory", SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_BINDINGS_DIR)).build());
        PATHS.put("journal-directory", SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_JOURNAL_DIR)).build());
        PATHS.put("large-messages-directory", SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_LARGE_MESSAGE_DIR)).build());
        PATHS.put("paging-directory", SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_PAGING_DIR)).build());
        PATH_ADD = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
                ModelNode model = resource.getModel();
                String path = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                for (AttributeDefinition attribute : MessagingPathHandlers.getAttributes(path)) {
                    attribute.validateAndSet(operation, model);
                }
                MessagingPathHandlers.reloadRequiredStep(context);
                context.stepCompleted();
            }
        };
        PATH_REMOVE = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.removeResource(PathAddress.EMPTY_ADDRESS);
                MessagingPathHandlers.reloadRequiredStep(context);
                context.stepCompleted();
            }
        };
    }
}

