/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import jakarta.jms.Topic;
import java.util.List;
import org.hornetq.api.jms.HornetQJMSClient;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicService;

public class JMSTopicAdd
extends AbstractAddStepHandler {
    public static final JMSTopicAdd INSTANCE = new JMSTopicAdd();

    private JMSTopicAdd() {
        super(JMSTopicDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress());
        ServiceTarget serviceTarget = context.getServiceTarget();
        JMSTopicService jmsTopicService = JMSTopicService.installService(name, serviceName, serviceTarget);
        ServiceName jmsTopicServiceName = JMSServices.getJmsTopicBaseServiceName(serviceName).append(new String[]{name});
        for (String entry : CommonAttributes.DESTINATION_ENTRIES.unwrap((ExpressionResolver)context, model)) {
            BinderServiceUtil.installBinderService(serviceTarget, entry, jmsTopicService, jmsTopicServiceName);
        }
        List legacyEntries = CommonAttributes.LEGACY_ENTRIES.unwrap((ExpressionResolver)context, model);
        if (!legacyEntries.isEmpty()) {
            Topic legacyTopic = HornetQJMSClient.createTopic((String)name);
            for (String legacyEntry : legacyEntries) {
                BinderServiceUtil.installBinderService(serviceTarget, legacyEntry, legacyTopic);
            }
        }
    }
}

