/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;

class ExternalConnectionFactoryConfiguration {
    private String name = null;
    private boolean persisted = false;
    private String[] bindings = null;
    private List<String> connectorNames = null;
    private String discoveryGroupName = null;
    private String clientID = null;
    private boolean ha = false;
    private long clientFailureCheckPeriod = ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    private long connectionTTL = ActiveMQClient.DEFAULT_CONNECTION_TTL;
    private long callTimeout = 30000L;
    private long callFailoverTimeout = 30000L;
    private boolean cacheLargeMessagesClient = false;
    private int minLargeMessageSize = 102400;
    private boolean compressLargeMessage = false;
    private int compressionLevel = -1;
    private int consumerWindowSize = 0x100000;
    private int consumerMaxRate = -1;
    private int confirmationWindowSize = -1;
    private int producerWindowSize = 65536;
    private int producerMaxRate = -1;
    private boolean blockOnAcknowledge = false;
    private boolean blockOnDurableSend = true;
    private boolean blockOnNonDurableSend = false;
    private boolean autoGroup = false;
    private boolean preAcknowledge = false;
    private String loadBalancingPolicyClassName = ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
    private int transactionBatchSize = 0x100000;
    private int dupsOKBatchSize = 0x100000;
    private long initialWaitTimeout = 10000L;
    private boolean useGlobalPools = true;
    private int scheduledThreadPoolMaxSize = 5;
    private int threadPoolMaxSize = -1;
    private long retryInterval = 2000L;
    private double retryIntervalMultiplier = ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    private long maxRetryInterval = ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL;
    private int reconnectAttempts = 0;
    private String groupID = null;
    private String protocolManagerFactoryStr;
    private JMSFactoryType factoryType = JMSFactoryType.CF;
    private String deserializationBlackList;
    private String deserializationWhiteList;
    private int initialMessagePacketSize = 1500;
    private boolean enable1xPrefixes = ActiveMQJMSClient.DEFAULT_ENABLE_1X_PREFIXES;
    private boolean enableSharedClientID = false;
    private boolean useTopologyForLoadBalancing = true;

    public String[] getBindings() {
        return this.bindings;
    }

    public ExternalConnectionFactoryConfiguration setBindings(String ... bindings) {
        this.bindings = bindings;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ExternalConnectionFactoryConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public ExternalConnectionFactoryConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    public List<String> getConnectorNames() {
        return this.connectorNames;
    }

    public ExternalConnectionFactoryConfiguration setConnectorNames(List<String> connectorNames) {
        this.connectorNames = connectorNames;
        return this;
    }

    public ExternalConnectionFactoryConfiguration setConnectorNames(String ... names) {
        return this.setConnectorNames(Arrays.asList(names));
    }

    public boolean isHA() {
        return this.ha;
    }

    public ExternalConnectionFactoryConfiguration setHA(boolean ha) {
        this.ha = ha;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public ExternalConnectionFactoryConfiguration setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public ExternalConnectionFactoryConfiguration setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public ExternalConnectionFactoryConfiguration setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public ExternalConnectionFactoryConfiguration setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    public ExternalConnectionFactoryConfiguration setCallFailoverTimeout(long callFailoverTimeout) {
        this.callFailoverTimeout = callFailoverTimeout;
        return this;
    }

    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    public ExternalConnectionFactoryConfiguration setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
        return this;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public ExternalConnectionFactoryConfiguration setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public ExternalConnectionFactoryConfiguration setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    public ExternalConnectionFactoryConfiguration setConsumerWindowSize(int consumerWindowSize) {
        this.consumerWindowSize = consumerWindowSize;
        return this;
    }

    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    public ExternalConnectionFactoryConfiguration setConsumerMaxRate(int consumerMaxRate) {
        this.consumerMaxRate = consumerMaxRate;
        return this;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public ExternalConnectionFactoryConfiguration setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    public ExternalConnectionFactoryConfiguration setProducerMaxRate(int producerMaxRate) {
        this.producerMaxRate = producerMaxRate;
        return this;
    }

    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public ExternalConnectionFactoryConfiguration setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
        return this;
    }

    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    public ExternalConnectionFactoryConfiguration setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.blockOnAcknowledge = blockOnAcknowledge;
        return this;
    }

    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    public ExternalConnectionFactoryConfiguration setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.blockOnDurableSend = blockOnDurableSend;
        return this;
    }

    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    public ExternalConnectionFactoryConfiguration setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        return this;
    }

    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    public ExternalConnectionFactoryConfiguration setAutoGroup(boolean autoGroup) {
        this.autoGroup = autoGroup;
        return this;
    }

    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    public ExternalConnectionFactoryConfiguration setPreAcknowledge(boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
        return this;
    }

    public String getLoadBalancingPolicyClassName() {
        return this.loadBalancingPolicyClassName;
    }

    public ExternalConnectionFactoryConfiguration setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.loadBalancingPolicyClassName = loadBalancingPolicyClassName;
        return this;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public ExternalConnectionFactoryConfiguration setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
        return this;
    }

    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public ExternalConnectionFactoryConfiguration setDupsOKBatchSize(int dupsOKBatchSize) {
        this.dupsOKBatchSize = dupsOKBatchSize;
        return this;
    }

    public long getInitialWaitTimeout() {
        return this.initialWaitTimeout;
    }

    public ExternalConnectionFactoryConfiguration setInitialWaitTimeout(long initialWaitTimeout) {
        this.initialWaitTimeout = initialWaitTimeout;
        return this;
    }

    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    public ExternalConnectionFactoryConfiguration setUseGlobalPools(boolean useGlobalPools) {
        this.useGlobalPools = useGlobalPools;
        return this;
    }

    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    public ExternalConnectionFactoryConfiguration setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
        return this;
    }

    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    public ExternalConnectionFactoryConfiguration setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public ExternalConnectionFactoryConfiguration setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public ExternalConnectionFactoryConfiguration setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public ExternalConnectionFactoryConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public ExternalConnectionFactoryConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    @Deprecated
    public boolean isFailoverOnInitialConnection() {
        return false;
    }

    @Deprecated
    public ExternalConnectionFactoryConfiguration setFailoverOnInitialConnection(boolean failover) {
        return this;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public ExternalConnectionFactoryConfiguration setGroupID(String groupID) {
        this.groupID = groupID;
        return this;
    }

    public boolean isEnable1xPrefixes() {
        return this.enable1xPrefixes;
    }

    public ExternalConnectionFactoryConfiguration setEnable1xPrefixes(boolean enable1xPrefixes) {
        this.enable1xPrefixes = enable1xPrefixes;
        return this;
    }

    public ExternalConnectionFactoryConfiguration setFactoryType(JMSFactoryType factoryType) {
        this.factoryType = factoryType;
        return this;
    }

    public JMSFactoryType getFactoryType() {
        return this.factoryType;
    }

    public String getDeserializationBlackList() {
        return this.deserializationBlackList;
    }

    public void setDeserializationBlackList(String blackList) {
        this.deserializationBlackList = blackList;
    }

    public String getDeserializationWhiteList() {
        return this.deserializationWhiteList;
    }

    public void setDeserializationWhiteList(String whiteList) {
        this.deserializationWhiteList = whiteList;
    }

    public ExternalConnectionFactoryConfiguration setCompressLargeMessages(boolean compressLargeMessage) {
        this.compressLargeMessage = compressLargeMessage;
        return this;
    }

    public boolean isCompressLargeMessages() {
        return this.compressLargeMessage;
    }

    public ExternalConnectionFactoryConfiguration setProtocolManagerFactoryStr(String protocolManagerFactoryStr) {
        this.protocolManagerFactoryStr = protocolManagerFactoryStr;
        return this;
    }

    public String getProtocolManagerFactoryStr() {
        return this.protocolManagerFactoryStr;
    }

    public int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    public ExternalConnectionFactoryConfiguration setInitialMessagePacketSize(int size) {
        this.initialMessagePacketSize = size;
        return this;
    }

    public ExternalConnectionFactoryConfiguration setEnableSharedClientID(boolean enabled) {
        this.enableSharedClientID = enabled;
        return this;
    }

    public boolean isEnableSharedClientID() {
        return this.enableSharedClientID;
    }

    public ExternalConnectionFactoryConfiguration setUseTopologyForLoadBalancing(boolean useTopologyForLoadBalancing) {
        this.useTopologyForLoadBalancing = useTopologyForLoadBalancing;
        return this;
    }

    public boolean getUseTopologyForLoadBalancing() {
        return this.useTopologyForLoadBalancing;
    }
}

