/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.jms.AbstractJMSRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;

public class PooledConnectionFactoryConfigurationRuntimeHandler
extends AbstractJMSRuntimeHandler<ModelNode> {
    public static final PooledConnectionFactoryConfigurationRuntimeHandler INSTANCE = new PooledConnectionFactoryConfigurationRuntimeHandler(false);
    public static final PooledConnectionFactoryConfigurationRuntimeHandler EXTERNAL_INSTANCE = new PooledConnectionFactoryConfigurationRuntimeHandler(true);
    private final boolean external;

    private PooledConnectionFactoryConfigurationRuntimeHandler(boolean external) {
        this.external = external;
    }

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, ModelNode connectionFactory, PathAddress address, boolean includeDefault) {
        if (connectionFactory.hasDefined(attributeName)) {
            context.getResult().set(connectionFactory.get(attributeName));
        } else {
            ConnectionFactoryAttribute attribute;
            ConnectionFactoryAttribute connectionFactoryAttribute = attribute = this.external ? ExternalPooledConnectionFactoryDefinition.getAttributesMap().get(attributeName) : PooledConnectionFactoryDefinition.getAttributesMap().get(attributeName);
            if (attribute != null && attribute.getDefinition().getDefaultValue() != null && attribute.getDefinition().getDefaultValue().isDefined()) {
                context.getResult().set(attribute.getDefinition().getDefaultValue());
            }
        }
    }
}

