/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ExternalJMSQueueAdd;
import org.wildfly.extension.messaging.activemq.jms.ExternalJMSQueueRemove;

public class ExternalJMSQueueDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX};
    private final boolean deployed;

    public ExternalJMSQueueDefinition(boolean deployed) {
        super(MessagingExtension.EXTERNAL_JMS_QUEUE_PATH, MessagingExtension.getResourceDescriptionResolver("external-jms-queue"), (OperationStepHandler)ExternalJMSQueueAdd.INSTANCE, (OperationStepHandler)ExternalJMSQueueRemove.INSTANCE);
        this.deployed = deployed;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(CommonAttributes.DESTINATION_ENTRIES, ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        if (this.deployed) {
            registry.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.DESTINATION_ENTRIES, null);
            registry.registerReadOnlyAttribute(ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX, null);
        } else {
            registry.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.DESTINATION_ENTRIES, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES}));
            registry.registerReadWriteAttribute(ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX}));
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.singletonList(MessagingExtension.JMS_QUEUE_ACCESS_CONSTRAINT);
    }
}

