/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class MessagingDependencyProcessor
implements DeploymentUnitProcessor {
    public static final String AS_MESSAGING = "org.wildfly.extension.messaging-activemq.injection";
    public static final String JMS_API = "jakarta.jms.api";
    public static final String JTS = "org.jboss.jts";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability api;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JMS_API);
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (support.hasCapability("org.wildfly.weld") && (api = (WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).isPartOfWeldDeployment(deploymentUnit)) {
            this.addDependency(moduleSpecification, moduleLoader, AS_MESSAGING);
            this.addDependency(moduleSpecification, moduleLoader, JTS);
        }
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String moduleIdentifier) {
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)moduleIdentifier).setImportServices(true).build());
    }
}

