/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.SocketDiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class SocketDiscoveryGroupAdd
extends AbstractAddStepHandler {
    public static final SocketDiscoveryGroupAdd INSTANCE = new SocketDiscoveryGroupAdd(true);
    public static final SocketDiscoveryGroupAdd LEGACY_INSTANCE = new SocketDiscoveryGroupAdd(false);
    private final boolean needLegacyCall;

    private SocketDiscoveryGroupAdd(boolean needLegacyCall) {
        super(SocketDiscoveryGroupDefinition.ATTRIBUTES);
        this.needLegacyCall = needLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        super.execute(context, operation);
        if (this.needLegacyCall) {
            PathAddress target = context.getCurrentAddress().getParent().append("discovery-group", context.getCurrentAddressValue());
            ModelNode op = operation.clone();
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)DiscoveryGroupAdd.LEGACY_INSTANCE, OperationContext.Stage.MODEL, true);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceController service;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController serviceController = service = serviceName == null ? null : registry.getService(serviceName);
        if (service != null) {
            context.reloadRequired();
        } else {
            ServiceTarget target = context.getServiceTarget();
            if (!model.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) && model.hasDefined(RemoteTransportDefinition.SOCKET_BINDING.getName())) {
                if (serviceName == null) {
                    serviceName = MessagingServices.getActiveMQServiceName((String)null);
                }
                ServiceBuilder builder = target.addService(GroupBindingService.getDiscoveryBaseServiceName(serviceName).append(new String[]{name}));
                builder.setInstance((Service)new GroupBindingService(builder.requires(SocketBindingResourceDefinition.SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(new String[]{model.get("socket-binding").asString()}))));
                builder.install();
            }
        }
    }

    static Map<String, DiscoveryGroupConfiguration> addDiscoveryGroupConfigs(OperationContext context, ModelNode model) throws OperationFailedException {
        HashMap<String, DiscoveryGroupConfiguration> configs = new HashMap<String, DiscoveryGroupConfiguration>();
        if (model.hasDefined("socket-discovery-group")) {
            for (Property prop : model.get("socket-discovery-group").asPropertyList()) {
                configs.put(prop.getName(), SocketDiscoveryGroupAdd.createDiscoveryGroupConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
        return configs;
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout);
    }

    public static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        if (socketBinding.getMulticastAddress() == null) {
            throw MessagingLogger.ROOT_LOGGER.socketBindingMulticastNotSet("socket-discovery-group", name, socketBinding.getName());
        }
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int groupPort = socketBinding.getMulticastPort();
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        UDPBroadcastEndpointFactory endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(-1);
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

