/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryStatisticsService;

public class ExternalPooledConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final ExternalPooledConnectionFactoryAdd INSTANCE = new ExternalPooledConnectionFactoryAdd();

    private ExternalPooledConnectionFactoryAdd() {
        super(ConnectionFactoryAttribute.getDefinitions(ExternalPooledConnectionFactoryDefinition.ATTRIBUTES));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        ModelNode resolvedModel = model.clone();
        for (Object attribute : this.attributes) {
            resolvedModel.get(attribute.getName()).set(attribute.resolveModelAttribute(context, resolvedModel));
        }
        ArrayList<String> jndiNames = new ArrayList<String>();
        for (ModelNode node : resolvedModel.get(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList()) {
            jndiNames.add(node.asString());
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)((String)jndiNames.get(0)));
        List<String> jndiAliases = jndiNames.size() > 1 ? new ArrayList(jndiNames.subList(1, jndiNames.size())) : Collections.emptyList();
        String managedConnectionPoolClassName = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()).asStringOrNull();
        int minPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).asInt();
        int maxPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).asInt();
        Boolean enlistmentTrace = resolvedModel.get(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName()).asBooleanOrNull();
        String txSupport = PooledConnectionFactoryAdd.getTxSupport(resolvedModel);
        List connectors = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        String discoveryGroupName = ExternalPooledConnectionFactoryAdd.getDiscoveryGroup(resolvedModel);
        String jgroupClusterName = null;
        String jgroupsChannelName = null;
        PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(address);
        if (discoveryGroupName != null) {
            Resource dgResource;
            PathAddress dgAddress;
            if (MessagingServices.isSubsystemResource(context)) {
                dgAddress = address.getParent().append("socket-discovery-group", discoveryGroupName);
                try {
                    dgResource = context.readResourceFromRoot(dgAddress, false);
                }
                catch (Resource.NoSuchResourceException ex) {
                    dgAddress = address.getParent().append("jgroups-discovery-group", discoveryGroupName);
                    dgResource = context.readResourceFromRoot(dgAddress, false);
                }
            } else {
                dgAddress = serverAddress.append("socket-discovery-group", discoveryGroupName);
                try {
                    dgResource = context.readResourceFromRoot(dgAddress, false);
                }
                catch (Resource.NoSuchResourceException ex) {
                    dgAddress = address.getParent().append("jgroups-discovery-group", discoveryGroupName);
                    dgResource = context.readResourceFromRoot(dgAddress, false);
                }
            }
            ModelNode dgModel = dgResource.getModel();
            ModelNode jgroupCluster = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, dgModel);
            if (jgroupCluster.isDefined()) {
                jgroupClusterName = jgroupCluster.asString();
                ModelNode channel = DiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, dgModel);
                if (channel.isDefined()) {
                    jgroupsChannelName = channel.asString();
                }
            }
        }
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(resolvedModel, context, ExternalPooledConnectionFactoryDefinition.ATTRIBUTES);
        DiscoveryGroupConfiguration discoveryGroupConfiguration = null;
        if (discoveryGroupName != null) {
            discoveryGroupConfiguration = ExternalConnectionFactoryAdd.getDiscoveryGroup(context, discoveryGroupName);
        }
        HashSet<String> connectorsSocketBindings = new HashSet<String>();
        TransportConfiguration[] transportConfigurations = TransportConfigOperationHandlers.processConnectors(context, connectors, connectorsSocketBindings);
        ExternalPooledConnectionFactoryService.installService(context, name, transportConfigurations, discoveryGroupConfiguration, connectorsSocketBindings, jgroupClusterName, jgroupsChannelName, adapterParams, bindInfo, jndiAliases, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, model);
        boolean statsEnabled = ConnectionFactoryAttributes.Pooled.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (statsEnabled) {
            PooledConnectionFactoryStatisticsService.registerStatisticsResources(resource);
            PooledConnectionFactoryAdd.installStatistics(context, name);
        }
    }

    static String getDiscoveryGroup(ModelNode model) {
        if (model.hasDefined(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName())) {
            return model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()).asString();
        }
        return null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            if (ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.equals(attr)) {
                if (!operation.hasDefined(ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.getName())) continue;
                ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST.validateAndSet(operation, model);
                continue;
            }
            if (ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.equals(attr)) {
                if (!operation.hasDefined(ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.getName())) continue;
                ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST.validateAndSet(operation, model);
                continue;
            }
            attr.validateAndSet(operation, model);
        }
    }
}

