/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.JMXSubsystemRootResource;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class JMXSubsystemAdd
extends AbstractAddStepHandler {
    private final ManagedAuditLogger auditLoggerInfo;
    private final JmxAuthorizer authorizer;

    JMXSubsystemAdd(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer) {
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        JMXSubsystemAdd.launchServices(context, model, verificationHandler, this.auditLoggerInfo, this.authorizer, newControllers);
    }

    static void launchServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController<?> controller;
        ModelNode recursiveModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        String resolvedDomain = JMXSubsystemAdd.getDomainName(context, recursiveModel, "resolved");
        String expressionsDomain = JMXSubsystemAdd.getDomainName(context, recursiveModel, "expression");
        boolean legacyWithProperPropertyFormat = false;
        if (model.hasDefined("proper-property-format")) {
            legacyWithProperPropertyFormat = ExposeModelResourceExpression.DOMAIN_NAME.resolveModelAttribute(context, recursiveModel).asBoolean();
        }
        boolean coreMBeanSensitivity = JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY.resolveModelAttribute(context, recursiveModel).asBoolean();
        boolean forStandalone = context.getProcessType() == ProcessType.STANDALONE_SERVER;
        ServiceController<?> serviceController = controller = verificationHandler != null ? MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, coreMBeanSensitivity, auditLoggerInfo, authorizer, forStandalone, new ServiceListener[]{verificationHandler}) : MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, coreMBeanSensitivity, auditLoggerInfo, authorizer, forStandalone, new ServiceListener[0]);
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    static String getDomainName(OperationContext context, ModelNode model, String child) throws OperationFailedException {
        if (!model.hasDefined("expose-model")) {
            return null;
        }
        if (!model.get("expose-model").hasDefined(child)) {
            return null;
        }
        ModelNode childModel = model.get(new String[]{"expose-model", child});
        return ExposeModelResource.getDomainNameAttribute(child).resolveModelAttribute(context, childModel).asString();
    }
}

