/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.jdr.CommonAttributes;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.JdrReportExtension;
import org.jboss.dmr.ModelNode;

public class JdrReportRequestHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "generate-jdr-report";
    static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("generate-jdr-report", (ResourceDescriptionResolver)JdrReportExtension.SUBSYSTEM_RESOLVER).setReplyParameters(new AttributeDefinition[]{CommonAttributes.START_TIME, CommonAttributes.END_TIME, CommonAttributes.REPORT_LOCATION}).setReadOnly().setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)JdrReportExtension.JDR_SENSITIVITY_DEF).build();
    private final Supplier<JdrReportCollector> collectorSupplier;

    JdrReportRequestHandler(Supplier<JdrReportCollector> collectorSupplier) {
        this.collectorSupplier = collectorSupplier;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                JdrReportCollector jdrCollector = JdrReportRequestHandler.this.collectorSupplier.get();
                if (jdrCollector == null) {
                    throw new IllegalStateException();
                }
                ModelNode response = context.getResult();
                JdrReport report = jdrCollector.collect();
                if (report.getStartTime() != null) {
                    response.get("start-time").set(report.getStartTime().longValue());
                }
                if (report.getEndTime() != null) {
                    response.get("end-time").set(report.getEndTime().longValue());
                }
                response.get("report-location").set(report.getLocation());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

