/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.rmi.ContainerAnalysis;
import org.jboss.as.jacorb.rmi.RMIIIOPViolationException;

class WorkCacheManager {
    private final Constructor constructor;
    private final Method initializer;
    private final Map<Class, SoftReference<ContainerAnalysis>> workDone;
    private final Map<InProgressKey, ContainerAnalysis> workInProgress;
    private final Map<ClassLoader, Set<Class<?>>> classesByLoader;

    WorkCacheManager(Class cls) {
        try {
            this.constructor = cls.getDeclaredConstructor(Class.class);
            this.initializer = cls.getDeclaredMethod("doAnalyze", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw JacORBMessages.MESSAGES.unexpectedException(ex);
        }
        this.workDone = new HashMap<Class, SoftReference<ContainerAnalysis>>();
        this.workInProgress = new HashMap<InProgressKey, ContainerAnalysis>();
        this.classesByLoader = new HashMap();
    }

    public void clearClassLoader(ClassLoader cl) {
        Set<Class<?>> classes = this.classesByLoader.remove(cl);
        if (classes != null) {
            for (Class<?> clazz : classes) {
                this.workDone.remove(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    ContainerAnalysis getAnalysis(Class cls) throws RMIIIOPViolationException {
        WorkCacheManager workCacheManager;
        boolean created;
        ContainerAnalysis ret;
        block28: {
            ContainerAnalysis containerAnalysis;
            ret = null;
            created = false;
            try {
                workCacheManager = this;
                // MONITORENTER : workCacheManager
                ret = this.lookupDone(cls);
                if (ret == null) break block28;
                containerAnalysis = ret;
                // MONITOREXIT : workCacheManager
                WorkCacheManager workCacheManager2 = this;
            }
            catch (Throwable throwable) {
                WorkCacheManager workCacheManager3 = this;
                // MONITORENTER : workCacheManager3
                if (created) {
                    this.workInProgress.remove(new InProgressKey(cls, Thread.currentThread()));
                    this.workDone.put(cls, new SoftReference<ContainerAnalysis>(ret));
                    ClassLoader classLoader = cls.getClassLoader();
                    if (classLoader != null) {
                        Set<Class<?>> classes = this.classesByLoader.get(classLoader);
                        if (classes == null) {
                            classes = new HashSet();
                            this.classesByLoader.put(classLoader, classes);
                        }
                        classes.add(cls);
                    }
                }
                this.notifyAll();
                // MONITOREXIT : workCacheManager3
                throw throwable;
            }
            if (created) {
                this.workInProgress.remove(new InProgressKey(cls, Thread.currentThread()));
                this.workDone.put(cls, new SoftReference<ContainerAnalysis>(ret));
                ClassLoader classLoader = cls.getClassLoader();
                if (classLoader != null) {
                    Set<Class<?>> classes = this.classesByLoader.get(classLoader);
                    if (classes == null) {
                        classes = new HashSet();
                        this.classesByLoader.put(classLoader, classes);
                    }
                    classes.add(cls);
                }
            }
            this.notifyAll();
            // MONITOREXIT : workCacheManager2
            return containerAnalysis;
        }
        ContainerAnalysis inProgress = this.workInProgress.get(new InProgressKey(cls, Thread.currentThread()));
        if (inProgress != null) {
            ContainerAnalysis containerAnalysis = inProgress;
            // MONITOREXIT : workCacheManager
            WorkCacheManager workCacheManager4 = this;
            // MONITORENTER : workCacheManager4
            if (created) {
                this.workInProgress.remove(new InProgressKey(cls, Thread.currentThread()));
                this.workDone.put(cls, new SoftReference<ContainerAnalysis>(ret));
                ClassLoader classLoader = cls.getClassLoader();
                if (classLoader != null) {
                    Set<Class<?>> classes = this.classesByLoader.get(classLoader);
                    if (classes == null) {
                        classes = new HashSet();
                        this.classesByLoader.put(classLoader, classes);
                    }
                    classes.add(cls);
                }
            }
            this.notifyAll();
            // MONITOREXIT : workCacheManager4
            return containerAnalysis;
        }
        ret = this.createWorkInProgress(cls);
        // MONITOREXIT : workCacheManager
        created = true;
        this.doTheWork(cls, ret);
        workCacheManager = this;
        if (created) {
            this.workInProgress.remove(new InProgressKey(cls, Thread.currentThread()));
            this.workDone.put(cls, new SoftReference<ContainerAnalysis>(ret));
            ClassLoader classLoader = cls.getClassLoader();
            if (classLoader != null) {
                Set<Class<?>> classes = this.classesByLoader.get(classLoader);
                if (classes == null) {
                    classes = new HashSet();
                    this.classesByLoader.put(classLoader, classes);
                }
                classes.add(cls);
            }
        }
        this.notifyAll();
        // MONITOREXIT : workCacheManager
        return ret;
    }

    private ContainerAnalysis lookupDone(Class cls) {
        SoftReference<ContainerAnalysis> ref = this.workDone.get(cls);
        if (ref == null) {
            return null;
        }
        ContainerAnalysis ret = ref.get();
        if (ret == null) {
            this.workDone.remove(cls);
        }
        return ret;
    }

    private ContainerAnalysis createWorkInProgress(Class cls) {
        ContainerAnalysis analysis;
        try {
            analysis = (ContainerAnalysis)this.constructor.newInstance(cls);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.workInProgress.put(new InProgressKey(cls, Thread.currentThread()), analysis);
        return analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTheWork(Class cls, ContainerAnalysis ret) throws RMIIIOPViolationException {
        try {
            this.initializer.invoke((Object)ret, new Object[0]);
        }
        catch (Throwable t) {
            WorkCacheManager workCacheManager = this;
            synchronized (workCacheManager) {
                this.workInProgress.remove(new InProgressKey(cls, Thread.currentThread()));
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof RMIIIOPViolationException) {
                throw (RMIIIOPViolationException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t.toString());
        }
    }

    private static class InProgressKey {
        final Class<?> clazz;
        final Thread thread;

        private InProgressKey(Class<?> clazz, Thread thread) {
            this.clazz = clazz;
            this.thread = thread;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InProgressKey that = (InProgressKey)o;
            if (this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null) {
                return false;
            }
            return !(this.thread != null ? !this.thread.equals(that.thread) : that.thread != null);
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + (this.thread != null ? this.thread.hashCode() : 0);
            return result;
        }
    }
}

