/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashSet;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.JacORBSubsystemParser;
import org.jboss.as.jacorb.JacORBSubsystemResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JacORBExtension
implements Extension {
    private static final JacORBSubsystemParser PARSER = JacORBSubsystemParser.INSTANCE;
    public static final String SUBSYSTEM_NAME = "jacorb";
    private static final String RESOURCE_NAME = JacORBExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, JacORBExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration subsystemRegistration = subsystem.registerSubsystemModel((ResourceDefinition)JacORBSubsystemResource.INSTANCE);
        subsystemRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
        if (context.isRegisterTransformers()) {
            JacORBExtension.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_0.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_1.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_2.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JacORBSubsystemParser.Namespace.JacORB_1_3.getUriString(), (XMLElementReader)PARSER);
    }

    protected static void registerTransformers(SubsystemRegistration subsystem) {
        ModelVersion version110 = ModelVersion.create((int)1, (int)1, (int)0);
        HashSet<String> expressionKeys = new HashSet<String>();
        for (AttributeDefinition def : JacORBSubsystemDefinitions.ATTRIBUTES_BY_NAME.values()) {
            if (!def.isAllowExpression()) continue;
            expressionKeys.add(def.getName());
        }
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, expressionKeys.toArray(new String[expressionKeys.size()]))).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return JacORBMessages.MESSAGES.cannotUseSecurityClient();
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.getType() == ModelType.STRING && attributeValue.asString().equals("client");
            }
        }, new String[]{"security"})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                String security = attributeValue.asString();
                if (security.equals("identity")) {
                    attributeValue.set("on");
                }
            }
        }, new String[]{"security"})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)version110);
    }

    private static ModelNode replaceSecurityClient(ModelNode model) {
        if (model.hasDefined("security") && model.get("security").asString().equals("client")) {
            model.get("security").set("off");
            model.get("properties").add("org.omg.PortableInterceptor.ORBInitializerClass.org.jboss.as.jacorb.csiv2.CSIv2Initializer", "");
            model.get("properties").add("org.omg.PortableInterceptor.ORBInitializerClass.org.jboss.as.jacorb.csiv2.SASClientInitializer", "");
            return model;
        }
        return null;
    }
}

