/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.coordination.DomainFinalResultHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.DomainRolloutStepHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainSlaveHandler;
import org.jboss.as.domain.controller.operations.coordination.OperationRouting;
import org.jboss.as.domain.controller.operations.coordination.OperationSlaveStepHandler;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.controller.operations.coordination.SecurityActions;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;

public class OperationCoordinatorStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final ContentRepository contentRepository;
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final OperationSlaveStepHandler localSlaveHandler;
    private final DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry;
    private volatile ExecutorService executorService;

    OperationCoordinatorStepHandler(LocalHostControllerInfo localHostControllerInfo, ContentRepository contentRepository, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, OperationSlaveStepHandler localSlaveHandler, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.contentRepository = contentRepository;
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.localSlaveHandler = localSlaveHandler;
        this.runtimeIgnoreTransformationRegistry = runtimeIgnoreTransformationRegistry;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        OperationRouting routing = OperationRouting.determineRouting(context, operation, this.localHostControllerInfo);
        if (!this.localHostControllerInfo.isMasterDomainController() && !routing.isLocalOnly(this.localHostControllerInfo.getLocalHostName())) {
            this.routeToMasterDomainController(context, operation);
        } else if (routing.getSingleHost() != null && !this.localHostControllerInfo.getLocalHostName().equals(routing.getSingleHost())) {
            if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Remote single host");
            }
            OperationCoordinatorStepHandler.configureDomainUUID(operation);
            this.executeDirect(context, operation);
        } else if (!routing.isTwoStep()) {
            this.executeDirect(context, operation);
        } else {
            this.executeTwoPhaseOperation(context, operation, routing);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private ExecutorService getExecutorService() {
        return this.executorService == null ? Executors.newSingleThreadExecutor() : this.executorService;
    }

    private void routeToMasterDomainController(OperationContext context, ModelNode operation) {
        context.getFailureDescription().set(DomainControllerMessages.MESSAGES.masterDomainControllerOnlyOperation(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address"))));
        context.stepCompleted();
    }

    private void executeDirect(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s executing direct", this.getClass().getSimpleName());
        }
        PrepareStepHandler.executeDirectOperation(context, operation);
    }

    private void executeTwoPhaseOperation(OperationContext context, ModelNode operation, OperationRouting routing) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Executing two-phase");
        }
        OperationCoordinatorStepHandler.configureDomainUUID(operation);
        DomainOperationContext overallContext = new DomainOperationContext(this.localHostControllerInfo);
        ModelNode rolloutPlan = operation.hasDefined("operation-headers") && operation.get("operation-headers").has("rollout-plan") ? operation.get("operation-headers").remove("rollout-plan") : new ModelNode();
        context.addStep((OperationStepHandler)new DomainFinalResultHandler(overallContext), OperationContext.Stage.MODEL);
        ModelNode slaveOp = operation.clone();
        slaveOp.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        slaveOp.protect();
        String localHostName = this.localHostControllerInfo.getLocalHostName();
        if (routing.isLocalCallNeeded(localHostName)) {
            ModelNode localResponse = overallContext.getCoordinatorResult();
            this.localSlaveHandler.addSteps(context, slaveOp.clone(), localResponse, false);
        }
        if (this.localHostControllerInfo.isMasterDomainController()) {
            HashSet<String> remoteHosts = new HashSet<String>(routing.getHosts());
            boolean global = remoteHosts.size() == 0;
            remoteHosts.remove(localHostName);
            if (remoteHosts.size() > 0 || global) {
                context.acquireControllerLock();
                if (global) {
                    remoteHosts.addAll(this.hostProxies.keySet());
                }
                HashMap<String, ProxyController> remoteProxies = new HashMap<String, ProxyController>();
                for (String host : remoteHosts) {
                    ProxyController proxy = this.hostProxies.get(host);
                    if (proxy != null) {
                        remoteProxies.put(host, proxy);
                        continue;
                    }
                    if (global) continue;
                    throw DomainControllerMessages.MESSAGES.invalidOperationTargetHost(host);
                }
                context.addStep(slaveOp.clone(), (OperationStepHandler)new DomainSlaveHandler(remoteProxies, overallContext, this.runtimeIgnoreTransformationRegistry), OperationContext.Stage.DOMAIN);
            }
        }
        context.addStep((OperationStepHandler)new DomainRolloutStepHandler(this.hostProxies, this.serverProxies, overallContext, rolloutPlan, this.getExecutorService()), OperationContext.Stage.DOMAIN);
        context.stepCompleted();
    }

    static void configureDomainUUID(ModelNode operation) {
        if (!operation.hasDefined("operation-headers") || !operation.get("operation-headers").hasDefined("domain-uuid")) {
            String domainUUID = UUID.randomUUID().toString();
            operation.get(new String[]{"operation-headers", "domain-uuid"}).set(domainUUID);
            AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
            if (accessContext != null) {
                accessContext.setDomainUuid(domainUUID);
            }
        }
    }
}

