/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.wildfly.extension.elytron.oidc.CredentialDefinition;
import org.wildfly.extension.elytron.oidc.ProviderAttributeDefinitions;
import org.wildfly.extension.elytron.oidc.SecureDeploymentDefinition;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;

final class OidcConfigService {
    private static final String CREDENTIALS_JSON_NAME = "credentials";
    private static final String REDIRECT_REWRITE_RULE_JSON_NAME = "redirect-rewrite-rules";
    private static final OidcConfigService INSTANCE = new OidcConfigService();
    private Map<String, ModelNode> realms = new HashMap<String, ModelNode>();
    private Map<String, ModelNode> providers = new HashMap<String, ModelNode>();
    private Map<String, ModelNode> secureDeployments = new HashMap<String, ModelNode>();

    public static OidcConfigService getInstance() {
        return INSTANCE;
    }

    private OidcConfigService() {
    }

    public void addRealm(String realmName, ModelNode model) {
        this.realms.put(realmName, model.clone());
    }

    public void updateRealm(String realmName, String attrName, ModelNode resolvedValue) {
        ModelNode realm = this.realms.get(realmName);
        realm.get(attrName).set(resolvedValue);
    }

    public void removeRealm(String realmName) {
        this.realms.remove(realmName);
    }

    public void addProvider(String providerName, ModelNode model) {
        this.providers.put(providerName, model.clone());
    }

    public void updateProvider(String providerName, String attrName, ModelNode resolvedValue) {
        ModelNode realm = this.providers.get(providerName);
        realm.get(attrName).set(resolvedValue);
    }

    public void removeProvider(String providerName) {
        this.providers.remove(providerName);
    }

    public void addSecureDeployment(String deploymentName, ModelNode model) {
        ModelNode deployment = model.clone();
        this.secureDeployments.put(deploymentName, deployment);
    }

    public void updateSecureDeployment(String deploymentName, String attrName, ModelNode resolvedValue) {
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        deployment.get(attrName).set(resolvedValue);
    }

    public void removeSecureDeployment(String deploymentName) {
        this.secureDeployments.remove(deploymentName);
    }

    public void addCredential(String deploymentName, String credentialName, ModelNode model) {
        ModelNode credentials = this.getCredentialsForDeployment(deploymentName);
        if (!credentials.isDefined()) {
            credentials = new ModelNode();
        }
        this.setCredential(credentialName, model, credentials);
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        deployment.get(CREDENTIALS_JSON_NAME).set(credentials);
    }

    private void setCredential(String credentialName, ModelNode model, ModelNode credentials) {
        if (credentialName.equals("secret")) {
            credentials.get(credentialName).set(model.get("secret").asString());
        } else {
            credentials.set(credentialName, this.getCredentialValue(model));
        }
    }

    private ModelNode getCredentialValue(ModelNode model) {
        ModelNode credential = new ModelNode();
        for (SimpleAttributeDefinition attribute : CredentialDefinition.ATTRIBUTES) {
            String attributeName = attribute.getName();
            ModelNode attributeValue = model.get(attributeName);
            if (!attributeValue.isDefined()) continue;
            credential.get(attributeName).set(attributeValue.asString());
        }
        return credential;
    }

    public void removeCredential(String deploymentName, String credentialName) {
        ModelNode credentials = this.getCredentialsForDeployment(deploymentName);
        if (!credentials.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotRemoveCredential(deploymentName);
        }
        credentials.remove(credentialName);
    }

    public void updateCredential(String deploymentName, String credentialName, ModelNode resolvedValue) {
        ModelNode credentials = this.getCredentialsForDeployment(deploymentName);
        if (!credentials.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotUpdateCredential(deploymentName);
        }
        this.setCredential(credentialName, resolvedValue, credentials);
    }

    private ModelNode getCredentialsForDeployment(String deploymentName) {
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        return deployment.get(CREDENTIALS_JSON_NAME);
    }

    public void addRedirectRewriteRule(String deploymentName, String redirectRewriteRuleName, ModelNode model) {
        ModelNode redirectRewritesRules = this.getRedirectRewriteRuleForDeployment(deploymentName);
        if (!redirectRewritesRules.isDefined()) {
            redirectRewritesRules = new ModelNode();
        }
        redirectRewritesRules.get(redirectRewriteRuleName).set(model.get("replacement").asString());
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        deployment.get(REDIRECT_REWRITE_RULE_JSON_NAME).set(redirectRewritesRules);
    }

    public void removeRedirectRewriteRule(String deploymentName, String redirectRewriteRuleName) {
        ModelNode redirectRewritesRules = this.getRedirectRewriteRuleForDeployment(deploymentName);
        if (!redirectRewritesRules.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotRemoveRedirectRuntimeRule(deploymentName);
        }
        redirectRewritesRules.remove(redirectRewriteRuleName);
    }

    public void updateRedirectRewriteRule(String deploymentName, String redirectRewriteRuleName, ModelNode resolvedValue) {
        ModelNode redirectRewritesRules = this.getRedirectRewriteRuleForDeployment(deploymentName);
        if (!redirectRewritesRules.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotUpdateRedirectRuntimeRule(deploymentName);
        }
        redirectRewritesRules.get(redirectRewriteRuleName).set(resolvedValue.get("replacement").asString());
    }

    private ModelNode getRedirectRewriteRuleForDeployment(String deploymentName) {
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        return deployment.get(REDIRECT_REWRITE_RULE_JSON_NAME);
    }

    protected boolean isDeploymentConfigured(DeploymentUnit deploymentUnit) {
        ModelNode deployment = this.getSecureDeployment(deploymentUnit);
        if (!deployment.isDefined()) {
            return false;
        }
        ModelNode resource = deployment.get(SecureDeploymentDefinition.RESOURCE.getName());
        ModelNode clientId = deployment.get(SecureDeploymentDefinition.CLIENT_ID.getName());
        return resource.isDefined() || clientId.isDefined();
    }

    public String getJSON(DeploymentUnit deploymentUnit) {
        ModelNode deployment = this.getSecureDeployment(deploymentUnit);
        return this.getJSON(deployment);
    }

    public String getJSON(String deploymentName) {
        return this.getJSON(deploymentName, false);
    }

    public String getJSON(String deploymentName, boolean convertToRealmConfiguration) {
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        return this.getJSON(deployment, convertToRealmConfiguration);
    }

    public void clear() {
        this.realms = new HashMap<String, ModelNode>();
        this.providers = new HashMap<String, ModelNode>();
        this.secureDeployments = new HashMap<String, ModelNode>();
    }

    private String getJSON(ModelNode deployment) {
        return this.getJSON(deployment, false);
    }

    private String getJSON(ModelNode deployment, boolean convertToRealmConfiguration) {
        ModelNode json = new ModelNode();
        ModelNode realmOrProvider = null;
        boolean removeProvider = false;
        String realmName = deployment.get("realm").asStringOrNull();
        if (realmName != null) {
            realmOrProvider = this.realms.get(realmName);
            json.get("realm").set(realmName);
        } else {
            String providerName = deployment.get("provider").asStringOrNull();
            if (providerName != null) {
                realmOrProvider = this.providers.get(providerName);
                removeProvider = true;
            }
        }
        if (realmOrProvider != null) {
            OidcConfigService.setJSONValues(json, realmOrProvider, Stream.of(ProviderAttributeDefinitions.ATTRIBUTES).map(AttributeDefinition::getName)::iterator);
        }
        OidcConfigService.setJSONValues(json, deployment, Stream.concat(SecureDeploymentDefinition.ALL_ATTRIBUTES.stream().map(AttributeDefinition::getName), Stream.of(CREDENTIALS_JSON_NAME, REDIRECT_REWRITE_RULE_JSON_NAME))::iterator);
        if (removeProvider) {
            json.remove("provider");
        }
        if (convertToRealmConfiguration) {
            String providerUrl;
            String clientId = json.get("client-id").asStringOrNull();
            if (clientId != null) {
                json.remove("client-id");
                json.get("resource").set(clientId);
            }
            if ((providerUrl = json.get("provider-url").asStringOrNull()) != null) {
                String[] authServerUrlAndRealm = providerUrl.split("/realms/");
                json.get("auth-server-url").set(authServerUrlAndRealm[0]);
                json.get("realm").set(authServerUrlAndRealm[1]);
                json.remove("provider-url");
            }
        }
        return json.toJSONString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setJSONValues(ModelNode json, ModelNode values, Iterable<String> keys) {
        ModelNode modelNode = values;
        synchronized (modelNode) {
            for (String key : keys) {
                if (!values.hasDefined(key)) continue;
                json.get(key).set(values.get(key));
            }
        }
    }

    public boolean isSecureDeployment(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        return this.secureDeployments.containsKey(deploymentName);
    }

    private ModelNode getSecureDeployment(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        return this.secureDeployments.containsKey(deploymentName) ? this.secureDeployments.get(deploymentName) : new ModelNode();
    }

    private String preferredDeploymentName(DeploymentUnit deploymentUnit) {
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return deploymentName;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return deploymentName;
        }
        String moduleName = webMetaData.getModuleName();
        if (moduleName != null) {
            return moduleName + ".war";
        }
        return deploymentName;
    }
}

