/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class EJB3SubsystemDefaultPoolWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private static final String STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config";
    private static final String DEFAULT_SLSB_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config.slsb-default";
    private static final String DEFAULT_MDB_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config.mdb-default";
    private static final String DEFAULT_ENTITY_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config.entity-default";
    public static final EJB3SubsystemDefaultPoolWriteHandler SLSB_POOL = new EJB3SubsystemDefaultPoolWriteHandler("org.wildfly.ejb3.pool-config.slsb-default", (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL);
    public static final EJB3SubsystemDefaultPoolWriteHandler MDB_POOL = new EJB3SubsystemDefaultPoolWriteHandler("org.wildfly.ejb3.pool-config.mdb-default", (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL);
    public static final EJB3SubsystemDefaultPoolWriteHandler ENTITY_BEAN_POOL = new EJB3SubsystemDefaultPoolWriteHandler("org.wildfly.ejb3.pool-config.entity-default", (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_ENTITY_BEAN_INSTANCE_POOL);
    private final String poolConfigCapabilityName;
    private final AttributeDefinition poolAttribute;

    public EJB3SubsystemDefaultPoolWriteHandler(String defaultPoolConfigCapabilityName, AttributeDefinition poolAttribute) {
        super(new AttributeDefinition[]{poolAttribute});
        this.poolConfigCapabilityName = defaultPoolConfigCapabilityName;
        this.poolAttribute = poolAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
        resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        model = resource.getModel();
        if (this.poolAttribute.getName().equals("default-slsb-instance-pool")) {
            if (oldValue.isDefined()) {
                newSLSBRequirementName = null;
                try {
                    if (!newValue.isDefined()) ** GOTO lbl49
                    resolvedNewValue = context.resolveExpressions(newValue);
                    newSLSBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.ejb3.pool-config", (String)resolvedNewValue.asString());
                    context.registerAdditionalCapabilityRequirement(newSLSBRequirementName, "org.wildfly.ejb3.pool-config.slsb-default", "default-slsb-instance-pool");
                }
                catch (OperationFailedException ofe) {
                    EjbLogger.ROOT_LOGGER.defaultPoolExpressionCouldNotBeResolved("default-slsb-instance-pool", model.get("default-slsb-instance-pool").asString());
                }
                finally {
                    oldSLSBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.ejb3.pool-config", (String)oldValue.asString());
                    if (!oldSLSBRequirementName.equals(newSLSBRequirementName)) {
                        context.deregisterCapabilityRequirement(oldSLSBRequirementName, "org.wildfly.ejb3.pool-config.slsb-default", "default-slsb-instance-pool");
                    }
                }
            } else if (newValue.isDefined()) {
                try {
                    context.registerCapability(EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_POOL_CONFIG_CAPABILITY);
                }
                catch (OperationFailedRuntimeException newSLSBRequirementName) {}
            }
        } else if (this.poolAttribute.getName().equals("default-mdb-instance-pool")) {
            if (oldValue.isDefined()) {
                newMDBRequirementName = null;
                try {
                    if (!newValue.isDefined()) ** GOTO lbl49
                    resolvedNewValue = context.resolveExpressions(newValue);
                    newMDBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.ejb3.pool-config", (String)resolvedNewValue.asString());
                    context.registerAdditionalCapabilityRequirement(newMDBRequirementName, "org.wildfly.ejb3.pool-config.mdb-default", "default-mdb-instance-pool");
                }
                catch (OperationFailedException ofe) {
                    EjbLogger.ROOT_LOGGER.defaultPoolExpressionCouldNotBeResolved("default-mdb-instance-pool", model.get("default-mdb-instance-pool").asString());
                }
                finally {
                    oldMDBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.ejb3.pool-config", (String)oldValue.asString());
                    if (!oldMDBRequirementName.equals(newMDBRequirementName)) {
                        context.deregisterCapabilityRequirement(oldMDBRequirementName, "org.wildfly.ejb3.pool-config.mdb-default", "default-mdb-instance-pool");
                    }
                }
            } else if (newValue.isDefined()) {
                try {
                    context.registerCapability(EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_POOL_CONFIG_CAPABILITY);
                }
                catch (OperationFailedRuntimeException var7_10) {
                    // empty catch block
                }
            }
        }
lbl49:
        // 14 sources

        super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updatePoolService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updatePoolService(context, restored);
    }

    void updatePoolService(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode poolName = this.poolAttribute.resolveModelAttribute(context, model);
        ServiceName poolConfigServiceName = context.getCapabilityServiceName(this.poolConfigCapabilityName, PoolConfig.class);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController existingDefaultPoolConfigService = serviceRegistry.getService(poolConfigServiceName);
        if (existingDefaultPoolConfigService != null) {
            context.removeService(existingDefaultPoolConfigService);
        }
        if (poolName.isDefined()) {
            ServiceName poolConfigDependencyServiceName = context.getCapabilityServiceName(STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME, PoolConfig.class, new String[]{poolName.asString()});
            ServiceBuilder sb = context.getServiceTarget().addService(poolConfigServiceName);
            Consumer poolConfigConsumer = sb.provides(new ServiceName[]{poolConfigServiceName});
            Supplier poolConfigSupplier = sb.requires(poolConfigDependencyServiceName);
            sb.setInstance((Service)new DefaultPoolConfigService(poolConfigConsumer, poolConfigSupplier)).install();
        }
    }

    private static final class DefaultPoolConfigService
    implements Service {
        private final Consumer<PoolConfig> poolConfigConsumer;
        private final Supplier<PoolConfig> poolConfigSupplier;

        private DefaultPoolConfigService(Consumer<PoolConfig> poolConfigConsumer, Supplier<PoolConfig> poolConfigSupplier) {
            this.poolConfigConsumer = poolConfigConsumer;
            this.poolConfigSupplier = poolConfigSupplier;
        }

        public void start(StartContext startContext) {
            this.poolConfigConsumer.accept(this.poolConfigSupplier.get());
        }

        public void stop(StopContext stopContext) {
            this.poolConfigConsumer.accept(null);
        }
    }
}

