/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleResourceDescriptorConfigurator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheProvider;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheFactoryServiceInstallerFactory;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.StatefulSessionBeanCacheProviderResourceDefinition;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ejb.DeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanConfiguration;
import org.wildfly.clustering.ejb.bean.BeanDeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DistributableStatefulSessionBeanCacheProviderResourceDefinition
extends StatefulSessionBeanCacheProviderResourceDefinition
implements Function<String, ServiceDependency<StatefulSessionBeanCacheProvider>> {
    public DistributableStatefulSessionBeanCacheProviderResourceDefinition() {
        super(EJB3SubsystemModel.DISTRIBUTABLE_CACHE_PATH, (UnaryOperator<ResourceDescriptor>)new SimpleResourceDescriptorConfigurator(Attribute.class));
    }

    public ServiceDependency<StatefulSessionBeanCacheProvider> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return this.apply(Attribute.BEAN_MANAGEMENT.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull());
    }

    @Override
    public ServiceDependency<StatefulSessionBeanCacheProvider> apply(String name) {
        return ServiceDependency.on((UnaryServiceDescriptor)BeanManagementProvider.SERVICE_DESCRIPTOR, (String)name).map((Function)new Function<BeanManagementProvider, StatefulSessionBeanCacheProvider>(){

            @Override
            public StatefulSessionBeanCacheProvider apply(final BeanManagementProvider provider) {
                return new StatefulSessionBeanCacheProvider(){

                    @Override
                    public boolean supportsPassivation() {
                        return true;
                    }

                    @Override
                    public Iterable<ServiceInstaller> getStatefulBeanCacheFactoryServiceInstallers(DeploymentUnit unit, StatefulComponentDescription description, ComponentConfiguration configuration) {
                        ServiceName name = unit.getServiceName().append(new String[]{configuration.getComponentName()}).append(new String[]{"bean-manager"});
                        ServiceInstaller beanManagerFactoryInstaller = provider.getBeanManagerFactoryServiceInstaller(name, (BeanConfiguration)new DeploymentUnitBeanConfiguration(provider, unit, configuration));
                        ServiceInstaller cacheFactoryInstaller = new DistributableStatefulSessionBeanCacheFactoryServiceInstallerFactory().apply(description, ServiceDependency.on((ServiceName)name));
                        return List.of(beanManagerFactoryInstaller, cacheFactoryInstaller);
                    }

                    @Override
                    public Iterable<ServiceInstaller> getDeploymentServiceInstallers(DeploymentUnit unit, EEModuleConfiguration moduleConfiguration) {
                        return provider.getDeploymentServiceInstallers((BeanDeploymentConfiguration)new BeanDeploymentUnitConfiguration(provider, unit, moduleConfiguration));
                    }
                };
            }
        });
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        BEAN_MANAGEMENT("bean-management", ModelType.STRING, CapabilityReferenceRecorder.builder(StatefulSessionBeanCacheProviderResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)BeanManagementProvider.SERVICE_DESCRIPTOR).build());

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, CapabilityReferenceRecorder<?> referenece) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setCapabilityReference(referenece)).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    private static class DeploymentUnitBeanConfiguration
    extends DeploymentUnitConfiguration
    implements BeanConfiguration {
        private final ComponentConfiguration configuration;

        DeploymentUnitBeanConfiguration(BeanManagementProvider provider, DeploymentUnit unit, ComponentConfiguration configuration) {
            super(provider, unit);
            this.configuration = configuration;
        }

        public String getName() {
            return this.configuration.getComponentName();
        }
    }

    private static class BeanDeploymentUnitConfiguration
    extends DeploymentUnitConfiguration
    implements BeanDeploymentConfiguration {
        private final Set<Class<?>> beanClasses = Collections.newSetFromMap(new IdentityHashMap());

        BeanDeploymentUnitConfiguration(BeanManagementProvider provider, DeploymentUnit unit, EEModuleConfiguration moduleConfiguration) {
            super(provider, unit);
            for (ComponentConfiguration configuration : moduleConfiguration.getComponentConfigurations()) {
                if (!(configuration.getComponentDescription() instanceof StatefulComponentDescription)) continue;
                for (Class componentClass = configuration.getComponentClass(); componentClass != Object.class; componentClass = componentClass.getSuperclass()) {
                    this.beanClasses.add(componentClass);
                }
            }
        }

        public Set<Class<?>> getBeanClasses() {
            return this.beanClasses;
        }
    }

    private static class DeploymentUnitConfiguration
    implements DeploymentConfiguration {
        private final String deploymentName;
        private final DeploymentUnit unit;

        DeploymentUnitConfiguration(BeanManagementProvider provider, DeploymentUnit unit) {
            ArrayList<String> parts = new ArrayList<String>(3);
            DeploymentUnit parent = unit.getParent();
            if (parent != null) {
                parts.add(parent.getServiceName().getSimpleName());
            }
            parts.add(unit.getServiceName().getSimpleName());
            parts.add(provider.getName());
            this.deploymentName = String.join((CharSequence)"/", parts);
            this.unit = unit;
        }

        public String getDeploymentName() {
            return this.deploymentName;
        }

        public ServiceName getDeploymentServiceName() {
            return this.unit.getServiceName();
        }

        public Module getModule() {
            return (Module)this.unit.getAttachment(Attachments.MODULE);
        }
    }
}

