/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ejb3.component.messagedriven.MdbDeliveryControllerService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.MdbDeliveryGroupResourceDefinition;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class MdbDeliveryDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        boolean clusteredSingletonFound = false;
        for (ComponentConfiguration configuration : moduleConfiguration.getComponentConfigurations()) {
            MessageDrivenComponentDescription mdbDescription;
            ComponentDescription description = configuration.getComponentDescription();
            if (!(description instanceof MessageDrivenComponentDescription) || !(mdbDescription = (MessageDrivenComponentDescription)description).isDeliveryControlled()) continue;
            ServiceBuilder builder = serviceTarget.addService(mdbDescription.getDeliveryControllerName());
            if (mdbDescription.isClusteredSingleton()) {
                clusteredSingletonFound = true;
                builder.requires(capabilityServiceSupport.getCapabilityServiceName(EJB3SubsystemRootResourceDefinition.CLUSTERED_SINGLETON));
            }
            if (mdbDescription.getDeliveryGroups() != null) {
                for (String deliveryGroup : mdbDescription.getDeliveryGroups()) {
                    if (!capabilityServiceSupport.hasCapability(MdbDeliveryGroupResourceDefinition.MDB_DELIVERY_GROUP, deliveryGroup)) {
                        throw EjbLogger.DEPLOYMENT_LOGGER.missingMdbDeliveryGroup(deliveryGroup);
                    }
                    builder.requires(capabilityServiceSupport.getCapabilityServiceName(MdbDeliveryGroupResourceDefinition.MDB_DELIVERY_GROUP, deliveryGroup));
                }
            }
            Supplier component = builder.requires(description.getCreateServiceName());
            builder.setInstance((Service)new MdbDeliveryControllerService(component)).setInitialMode(ServiceController.Mode.PASSIVE).install();
        }
        if (clusteredSingletonFound) {
            ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Object)Boolean.TRUE).requires((Consumer)ServiceDependency.on(EJB3SubsystemRootResourceDefinition.CLUSTERED_SINGLETON_BARRIER))).build()).install(phaseContext);
        }
    }
}

