/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.TransactionManagementType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.interceptors.ComponentTypeIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentSessionIdGeneratingInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulIdentityInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulInitMethodInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulRemoteViewInstanceFactory;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanObjectViewConfigurator;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionSynchronizationInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.component.stateful.StatefulWriteReplaceInterceptor;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheProvider;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.LifecycleCMTTxInterceptor;
import org.jboss.as.ejb3.tx.StatefulBMTInterceptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class StatefulComponentDescription
extends SessionBeanComponentDescription {
    private Method afterBegin;
    private Method afterCompletion;
    private Method beforeCompletion;
    private final Map<MethodIdentifier, StatefulRemoveMethod> removeMethods = new HashMap<MethodIdentifier, StatefulRemoveMethod>();
    private StatefulTimeoutInfo statefulTimeout;
    private CacheInfo cache;
    private boolean passivationApplicable = true;
    private final ServiceName deploymentUnitServiceName;
    private final Map<Method, String> initMethods = new HashMap<Method, String>(0);

    public StatefulComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, DeploymentUnit deploymentUnit, SessionBeanMetaData descriptorData) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnit, descriptorData);
        this.deploymentUnitServiceName = deploymentUnit.getServiceName();
        this.addInitMethodInvokingInterceptor();
    }

    private void addInitMethodInvokingInterceptor() {
        this.getConfigurators().addFirst(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addPostConstructInterceptor(StatefulInitMethodInterceptor.INSTANCE, 4608);
            }
        });
    }

    private void addStatefulSessionSynchronizationInterceptor() {
        this.getConfigurators().addFirst(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                InterceptorFactory interceptorFactory = StatefulSessionSynchronizationInterceptor.factory(StatefulComponentDescription.this.getTransactionManagementType());
                configuration.addComponentInterceptor(interceptorFactory, 1280, false);
            }
        });
    }

    public ComponentConfiguration createConfiguration(ClassReflectionIndex classIndex, ClassLoader moduleClassLoader, ModuleLoader moduleLoader) {
        final ComponentConfiguration statefulComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, classIndex, moduleClassLoader, moduleLoader);
        statefulComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new StatefulComponentCreateServiceFactory());
        if (this.getTransactionManagementType() == TransactionManagementType.BEAN) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    ComponentInstanceInterceptorFactory bmtComponentInterceptorFactory = new ComponentInstanceInterceptorFactory(){

                        protected Interceptor create(Component component, InterceptorFactoryContext context) {
                            if (!(component instanceof StatefulSessionComponent)) {
                                throw EjbLogger.ROOT_LOGGER.componentNotInstanceOfSessionComponent(component, component.getComponentClass(), "stateful");
                            }
                            return new StatefulBMTInterceptor((StatefulSessionComponent)component);
                        }
                    };
                    configuration.addComponentInterceptor((InterceptorFactory)bmtComponentInterceptorFactory, 1312, false);
                }
            });
        } else {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    EEApplicationClasses applicationClasses = (EEApplicationClasses)context.getDeploymentUnit().getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
                    InterceptorClassDescription interceptorConfig = ComponentDescription.mergeInterceptorConfig((Class)configuration.getComponentClass(), (EEModuleClassDescription)applicationClasses.getClassByName(description.getComponentClassName()), (ComponentDescription)description, (boolean)MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)context.getDeploymentUnit()));
                    configuration.addPostConstructInterceptor((InterceptorFactory)new LifecycleCMTTxInterceptor.Factory(interceptorConfig.getPostConstruct(), false), 1280);
                    configuration.addPreDestroyInterceptor((InterceptorFactory)new LifecycleCMTTxInterceptor.Factory(interceptorConfig.getPreDestroy(), false), 768);
                    if (description.isPassivationApplicable()) {
                        configuration.addPrePassivateInterceptor((InterceptorFactory)new LifecycleCMTTxInterceptor.Factory(interceptorConfig.getPrePassivate(), false), 768);
                        configuration.addPostActivateInterceptor((InterceptorFactory)new LifecycleCMTTxInterceptor.Factory(interceptorConfig.getPostActivate(), false), 768);
                    }
                }
            });
        }
        this.addStatefulSessionSynchronizationInterceptor();
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                final DeploymentUnit unit = context.getDeploymentUnit();
                final StatefulComponentDescription statefulDescription = (StatefulComponentDescription)description;
                final ServiceDependency<StatefulSessionBeanCacheProvider> provider = this.getStatefulSessionBeanCacheProvider(statefulDescription);
                ServiceInstaller installer = new ServiceInstaller(){

                    public ServiceController<?> install(RequirementServiceTarget target) {
                        for (ServiceInstaller factoryInstaller : ((StatefulSessionBeanCacheProvider)provider.get()).getStatefulBeanCacheFactoryServiceInstallers(unit, statefulDescription, statefulComponentConfiguration)) {
                            factoryInstaller.install((ServiceTarget)target);
                        }
                        return null;
                    }
                };
                ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)installer, (CapabilityServiceSupport)((CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT))).requires(provider)).build()).install(context);
            }

            private ServiceDependency<StatefulSessionBeanCacheProvider> getStatefulSessionBeanCacheProvider(StatefulComponentDescription description) {
                if (!description.isPassivationApplicable()) {
                    return ServiceDependency.on(StatefulSessionBeanCacheProvider.PASSIVATION_DISABLED_SERVICE_DESCRIPTOR);
                }
                CacheInfo cache = description.getCache();
                return cache != null ? ServiceDependency.on(StatefulSessionBeanCacheProvider.SERVICE_DESCRIPTOR, (String)cache.getName()) : ServiceDependency.on(StatefulSessionBeanCacheProvider.DEFAULT_SERVICE_DESCRIPTOR);
            }
        });
        return statefulComponentConfiguration;
    }

    public Method getAfterBegin() {
        return this.afterBegin;
    }

    public Method getAfterCompletion() {
        return this.afterCompletion;
    }

    public Method getBeforeCompletion() {
        return this.beforeCompletion;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.STATEFUL;
    }

    public void setAfterBegin(Method afterBegin) {
        this.afterBegin = afterBegin;
    }

    public void setAfterCompletion(Method afterCompletion) {
        this.afterCompletion = afterCompletion;
    }

    public void setBeforeCompletion(Method afterCompletion) {
        this.beforeCompletion = afterCompletion;
    }

    @Override
    protected void setupViewInterceptors(EJBViewDescription view) {
        super.setupViewInterceptors(view);
        this.addRemoveMethodInterceptor(view);
        this.addStatefulInstanceAssociatingInterceptor(view);
        this.addViewSerializationInterceptor(view);
        if (view.getMethodIntf() == MethodInterfaceType.Remote) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                    configuration.setViewInstanceFactory((ViewInstanceFactory)new StatefulRemoteViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                }
            });
        }
    }

    @Override
    protected ViewConfigurator getSessionBeanObjectViewConfigurator() {
        return StatefulSessionBeanObjectViewConfigurator.INSTANCE;
    }

    private void addViewSerializationInterceptor(ViewDescription view) {
        view.setSerializable(true);
        view.setUseWriteReplace(true);
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                DeploymentReflectionIndex index = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
                ClassReflectionIndex classIndex = index.getClassIndex(WriteReplaceInterface.class);
                for (Method method : classIndex.getMethods()) {
                    configuration.addClientInterceptor(method, (InterceptorFactory)new StatefulWriteReplaceInterceptor.Factory(configuration.getViewServiceName().getCanonicalName()), 1280);
                }
            }
        });
    }

    public void addRemoveMethod(MethodIdentifier removeMethod, boolean retainIfException) {
        if (removeMethod == null) {
            throw EjbLogger.ROOT_LOGGER.removeMethodIsNull();
        }
        this.removeMethods.put(removeMethod, new StatefulRemoveMethod(removeMethod, retainIfException));
    }

    public Collection<StatefulRemoveMethod> getRemoveMethods() {
        return this.removeMethods.values();
    }

    public StatefulTimeoutInfo getStatefulTimeout() {
        return this.statefulTimeout;
    }

    public void setStatefulTimeout(StatefulTimeoutInfo statefulTimeout) {
        this.statefulTimeout = statefulTimeout;
    }

    private void addStatefulInstanceAssociatingInterceptor(final EJBViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                EJBViewDescription ejbViewDescription = view;
                if (ejbViewDescription.getMethodIntf() == MethodInterfaceType.Home || ejbViewDescription.getMethodIntf() == MethodInterfaceType.LocalHome) {
                    for (Method method : viewConfiguration.getProxyFactory().getCachedMethods()) {
                        if ((!method.getName().equals("hashCode") || method.getParameterCount() != 0) && (!method.getName().equals("equals") || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                        viewConfiguration.addClientInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 1024);
                    }
                } else {
                    InterceptorFactory sessionIdGeneratingInterceptorFactory = StatefulComponentSessionIdGeneratingInterceptor.FACTORY;
                    viewConfiguration.addClientPostConstructInterceptor(sessionIdGeneratingInterceptorFactory, 256);
                    for (Method method : viewConfiguration.getProxyFactory().getCachedMethods()) {
                        if ((!method.getName().equals("hashCode") || method.getParameterCount() != 0) && (!method.getName().equals("equals") || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                        viewConfiguration.addClientInterceptor(method, StatefulIdentityInterceptor.FACTORY, 1024);
                    }
                }
            }
        });
        if (view.getMethodIntf() != MethodInterfaceType.LocalHome && view.getMethodIntf() != MethodInterfaceType.Home) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addViewInterceptor(StatefulComponentInstanceInterceptor.FACTORY, 1792);
                }
            });
        }
    }

    private void addRemoveMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                StatefulComponentDescription statefulComponentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
                Collection<StatefulRemoveMethod> removeMethods = statefulComponentDescription.getRemoveMethods();
                if (removeMethods.isEmpty()) {
                    return;
                }
                block0: for (Method viewMethod : configuration.getProxyFactory().getCachedMethods()) {
                    MethodIdentifier viewMethodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)viewMethod);
                    for (StatefulRemoveMethod removeMethod : removeMethods) {
                        boolean object;
                        if (!removeMethod.methodIdentifier.equals(viewMethodIdentifier)) continue;
                        boolean bl = object = EJBObject.class.isAssignableFrom(configuration.getViewClass()) || EJBLocalObject.class.isAssignableFrom(configuration.getViewClass());
                        if (object && viewMethodIdentifier.getName().equals("remove") && viewMethodIdentifier.getParameterTypes().length == 0) continue block0;
                        configuration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(removeMethod.retainIfException)), 2304);
                        continue block0;
                    }
                }
            }
        });
    }

    public void addInitMethod(Method method, String createMethod) {
        this.initMethods.put(method, createMethod);
    }

    public Map<Method, String> getInitMethods() {
        return Collections.unmodifiableMap(this.initMethods);
    }

    public CacheInfo getCache() {
        return this.cache;
    }

    public void setCache(CacheInfo cache) {
        this.cache = cache;
    }

    public boolean isPassivationApplicable() {
        return this.passivationApplicable;
    }

    public void setPassivationApplicable(boolean passivationApplicable) {
        this.passivationApplicable = passivationApplicable;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }

    public boolean isTimerServiceRequired() {
        return false;
    }

    public ServiceName getDeploymentUnitServiceName() {
        return this.deploymentUnitServiceName;
    }

    public ServiceName getCacheFactoryServiceName() {
        return this.getServiceName().append(new String[]{"cache"});
    }

    public static final class StatefulRemoveMethod {
        private final MethodIdentifier methodIdentifier;
        private final boolean retainIfException;

        StatefulRemoveMethod(MethodIdentifier method, boolean retainIfException) {
            if (method == null) {
                throw EjbLogger.ROOT_LOGGER.removeMethodIsNull();
            }
            this.methodIdentifier = method;
            this.retainIfException = retainIfException;
        }

        public MethodIdentifier getMethodIdentifier() {
            return this.methodIdentifier;
        }

        public boolean getRetainIfException() {
            return this.retainIfException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatefulRemoveMethod that = (StatefulRemoveMethod)o;
            return this.methodIdentifier.equals(that.methodIdentifier);
        }

        public int hashCode() {
            return this.methodIdentifier.hashCode();
        }
    }
}

