/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import jakarta.ejb.EJBException;
import jakarta.ejb.EJBTransactionRolledbackException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.ejb3.tx.util.StatusHelper;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;

public class CMTTxInterceptor
implements Interceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new CMTTxInterceptor());

    protected void endTransaction(Transaction tx) {
        block8: {
            ContextTransactionManager tm = ContextTransactionManager.getInstance();
            try {
                if (!tx.equals(tm.getTransaction())) {
                    throw EjbLogger.ROOT_LOGGER.wrongTxOnThread(tx, (Transaction)tm.getTransaction());
                }
                int txStatus = tx.getStatus();
                if (txStatus == 0) {
                    tm.commit();
                    break block8;
                }
                if (txStatus == 1) {
                    tm.rollback();
                    break block8;
                }
                if (txStatus == 4 || txStatus == 9) {
                    tm.rollback();
                    throw EjbLogger.ROOT_LOGGER.transactionAlreadyRolledBack(tx);
                }
                if (txStatus == 5) {
                    tm.rollback();
                    throw EjbLogger.ROOT_LOGGER.transactionInUnexpectedState(tx, StatusHelper.statusAsString(txStatus));
                }
                tm.suspend();
                throw EjbLogger.ROOT_LOGGER.transactionInUnexpectedState(tx, StatusHelper.statusAsString(txStatus));
            }
            catch (RollbackException e) {
                throw new EJBTransactionRolledbackException(e.toString(), (Exception)((Object)e));
            }
            catch (HeuristicMixedException | HeuristicRollbackException | SystemException e) {
                throw new EJBException((Exception)e);
            }
        }
    }

    private void endTransaction(Transaction tx, Throwable outerEx) {
        try {
            this.endTransaction(tx);
        }
        catch (Throwable t) {
            outerEx.addSuppressed(t);
        }
    }

    /*
     * Exception decompiling
     */
    public Object processInvocation(InterceptorContext invocation) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Object invokeInImportedTx(InterceptorContext invocation, EJBComponent component) throws Exception {
        Object result;
        Transaction tx;
        try {
            tx = invocation.getTransaction();
        }
        catch (SystemException ex) {
            if (component != null && component.getEjbSuspendHandlerService().isSuspended()) {
                throw EjbLogger.ROOT_LOGGER.cannotBeginUserTransaction();
            }
            throw new EJBException((Exception)((Object)ex));
        }
        this.safeResume(tx);
        try {
            result = this.invokeInCallerTx(invocation, tx, component);
        }
        catch (Throwable t) {
            this.safeSuspend(t);
            throw t;
        }
        this.safeSuspend();
        return result;
    }

    protected Object invokeInCallerTx(InterceptorContext invocation, Transaction tx, EJBComponent component) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Error e) {
            EJBTransactionRolledbackException e2 = EjbLogger.ROOT_LOGGER.unexpectedErrorRolledBack(e);
            this.setRollbackOnly(tx, e2);
            throw e2;
        }
        catch (Exception e) {
            ApplicationExceptionDetails ae = component.getApplicationException(e.getClass(), invocation.getMethod());
            if (ae != null) {
                if (ae.isRollback()) {
                    this.setRollbackOnly(tx, e);
                }
                throw e;
            }
            try {
                throw e;
            }
            catch (EJBTransactionRolledbackException | NoSuchEJBException | NoSuchEntityException e2) {
                this.setRollbackOnly(tx, e2);
                throw e2;
            }
            catch (RuntimeException e2) {
                EJBTransactionRolledbackException e3 = new EJBTransactionRolledbackException(e2.getMessage(), (Exception)e2);
                this.setRollbackOnly(tx, e3);
                throw e3;
            }
        }
        catch (Throwable t) {
            EJBException e = new EJBException((Exception)new UndeclaredThrowableException(t));
            this.setRollbackOnly(tx, e);
            throw e;
        }
    }

    protected Object invokeInNoTx(InterceptorContext invocation, EJBComponent component) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Error e) {
            throw EjbLogger.ROOT_LOGGER.unexpectedError(e);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (RuntimeException e) {
            ApplicationExceptionDetails ae = component.getApplicationException(e.getClass(), invocation.getMethod());
            throw ae != null ? e : new EJBException((Exception)e);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EJBException((Exception)new UndeclaredThrowableException(t));
        }
    }

    protected Object invokeInOurTx(InterceptorContext invocation, EJBComponent component) throws Exception {
        RuntimeException except;
        Object result;
        AbstractTransaction tx;
        block15: {
            ContextTransactionManager tm = ContextTransactionManager.getInstance();
            tm.begin();
            tx = tm.getTransaction();
            result = null;
            except = null;
            try {
                result = invocation.proceed();
            }
            catch (Throwable t) {
                ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
                try {
                    try {
                        throw t;
                    }
                    catch (EJBException | RemoteException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (ae != null && !ae.isRollback()) {
                            except = e;
                            break block15;
                        }
                        if (ae != null && ae.isRollback()) {
                            throw e;
                        }
                        throw new EJBException((Exception)e);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw EjbLogger.ROOT_LOGGER.unexpectedError(e);
                    }
                    catch (Throwable e) {
                        throw new EJBException((Exception)new UndeclaredThrowableException(e));
                    }
                }
                catch (Throwable t2) {
                    if (ae == null || ae.isRollback()) {
                        this.setRollbackOnly((Transaction)tx, t2);
                    }
                    this.endTransaction((Transaction)tx, t2);
                    throw t2;
                }
            }
        }
        boolean rolledBack = this.safeGetStatus(tx) == 1;
        this.endTransaction((Transaction)tx);
        if (except != null) {
            throw except;
        }
        if (rolledBack) {
            this.ourTxRolledBack();
        }
        return result;
    }

    private int safeGetStatus(AbstractTransaction tx) {
        try {
            return tx.getStatus();
        }
        catch (SystemException e) {
            return 5;
        }
    }

    private void safeSuspend() {
        try {
            ContextTransactionManager.getInstance().suspend();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private void safeSuspend(Throwable t) {
        try {
            ContextTransactionManager.getInstance().suspend();
        }
        catch (SystemException e) {
            t.addSuppressed(e);
        }
    }

    private void safeResume(Transaction tx) {
        try {
            ContextTransactionManager.getInstance().resume(tx);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void safeResume(Transaction tx, Throwable t) {
        try {
            ContextTransactionManager.getInstance().resume(tx);
        }
        catch (Exception e) {
            t.addSuppressed(e);
        }
    }

    protected void ourTxRolledBack() {
    }

    protected Object mandatory(InterceptorContext invocation, EJBComponent component) throws Exception {
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        AbstractTransaction tx = tm.getTransaction();
        if (tx == null) {
            if (invocation.hasTransaction()) {
                return this.invokeInImportedTx(invocation, component);
            }
            throw EjbLogger.ROOT_LOGGER.txRequiredForInvocation(invocation);
        }
        return this.invokeInCallerTx(invocation, (Transaction)tx, component);
    }

    protected Object never(InterceptorContext invocation, EJBComponent component) throws Exception {
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        if (tm.getTransaction() != null || invocation.hasTransaction()) {
            throw EjbLogger.ROOT_LOGGER.txPresentForNeverTxAttribute();
        }
        return this.invokeInNoTx(invocation, component);
    }

    protected Object notSupported(InterceptorContext invocation, EJBComponent component) throws Exception {
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        AbstractTransaction tx = tm.getTransaction();
        if (tx != null) {
            Object result;
            this.safeSuspend();
            try {
                result = this.invokeInNoTx(invocation, component);
            }
            catch (Throwable t) {
                this.safeResume((Transaction)tx, t);
                throw t;
            }
            this.safeResume((Transaction)tx);
            return result;
        }
        return this.invokeInNoTx(invocation, component);
    }

    protected Object required(InterceptorContext invocation, EJBComponent component, int timeout) throws Exception {
        AbstractTransaction tx;
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        if (timeout != -1) {
            tm.setTransactionTimeout(timeout);
        }
        if ((tx = tm.getTransaction()) == null) {
            if (invocation.hasTransaction()) {
                return this.invokeInImportedTx(invocation, component);
            }
            return this.invokeInOurTx(invocation, component);
        }
        return this.invokeInCallerTx(invocation, (Transaction)tx, component);
    }

    protected Object requiresNew(InterceptorContext invocation, EJBComponent component, int timeout) throws Exception {
        AbstractTransaction tx;
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        if (timeout != -1) {
            tm.setTransactionTimeout(timeout);
        }
        if ((tx = tm.getTransaction()) != null) {
            Object result;
            this.safeSuspend();
            try {
                result = this.invokeInOurTx(invocation, component);
            }
            catch (Throwable t) {
                this.safeResume((Transaction)tx, t);
                throw t;
            }
            this.safeResume((Transaction)tx);
            return result;
        }
        return this.invokeInOurTx(invocation, component);
    }

    protected void setRollbackOnly(Transaction tx, Throwable t) {
        block2: {
            try {
                tx.setRollbackOnly();
            }
            catch (Throwable t2) {
                EjbLogger.ROOT_LOGGER.failedToSetRollbackOnly(t2);
                if (t == null) break block2;
                t.addSuppressed(t2);
            }
        }
    }

    protected Object supports(InterceptorContext invocation, EJBComponent component) throws Exception {
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        AbstractTransaction tx = tm.getTransaction();
        if (tx == null) {
            if (invocation.hasTransaction()) {
                return this.invokeInImportedTx(invocation, component);
            }
            return this.invokeInNoTx(invocation, component);
        }
        return this.invokeInCallerTx(invocation, (Transaction)tx, component);
    }
}

