/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.function.Function;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;

final class IdentityOutflowInterceptor
implements Interceptor {
    private final Function<SecurityIdentity, Set<SecurityIdentity>> identityOutflowFunction;
    private final String category;
    private final RoleMapper roleMapper;

    IdentityOutflowInterceptor(Function<SecurityIdentity, Set<SecurityIdentity>> identityOutflowFunction) {
        this(identityOutflowFunction, null, null);
    }

    IdentityOutflowInterceptor(Function<SecurityIdentity, Set<SecurityIdentity>> identityOutflowFunction, String category, RoleMapper roleMapper) {
        this.identityOutflowFunction = identityOutflowFunction;
        this.category = category;
        this.roleMapper = roleMapper;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        if (this.identityOutflowFunction != null) {
            SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
            SecurityIdentity currentIdentity = securityDomain.getCurrentSecurityIdentity();
            Set<SecurityIdentity> outflowedIdentities = this.identityOutflowFunction.apply(currentIdentity);
            SecurityIdentity[] newIdentities = this.category != null && this.roleMapper != null ? (SecurityIdentity[])outflowedIdentities.stream().map(outflowedIdentity -> {
                RoleMapper mergeMapper = this.roleMapper.or(roles -> outflowedIdentity.getRoles(this.category));
                return outflowedIdentity.withRoleMapper(this.category, mergeMapper);
            }).toArray(SecurityIdentity[]::new) : outflowedIdentities.toArray(new SecurityIdentity[outflowedIdentities.size()]);
            return SecurityIdentity.runAsAll((PrivilegedExceptionAction)context, (SecurityIdentity[])newIdentities);
        }
        return context.proceed();
    }
}

