/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.concurrent.TimeUnit;
import javax.ejb.StatefulTimeout;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;

public class StatefulTimeoutMergingProcessor
extends AbstractMergingProcessor<StatefulComponentDescription> {
    public StatefulTimeoutMergingProcessor() {
        super(StatefulComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation timeout = clazz.getAnnotationInformation(StatefulTimeout.class);
        if (timeout == null) {
            return;
        }
        if (!timeout.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setStatefulTimeout((StatefulTimeoutInfo)timeout.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        SessionBean31MetaData sessionBean31MetaData;
        StatefulTimeoutMetaData statefulTimeout;
        SessionBeanMetaData data = componentConfiguration.getDescriptorData();
        if (data == null) {
            return;
        }
        if (data instanceof SessionBean31MetaData && (statefulTimeout = (sessionBean31MetaData = (SessionBean31MetaData)data).getStatefulTimeout()) != null) {
            TimeUnit unit = TimeUnit.MINUTES;
            if (statefulTimeout.getUnit() != null) {
                unit = statefulTimeout.getUnit();
            }
            componentConfiguration.setStatefulTimeout(new StatefulTimeoutInfo(statefulTimeout.getTimeout(), unit));
        }
    }
}

