/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.ejb3.remote.ClientMappingsRegistryBuilder;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.remote.EJBRemotingConnectorClientMappingsEntryProviderService;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.clustering.spi.CacheBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;
import org.wildfly.clustering.spi.LocalCacheBuilderProvider;
import org.wildfly.clustering.spi.LocalGroupBuilderProvider;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class EJB3RemoteServiceAdd
extends AbstractBoottimeAddStepHandler {
    static final EJB3RemoteServiceAdd INSTANCE = new EJB3RemoteServiceAdd();

    private EJB3RemoteServiceAdd() {
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.installRuntimeServices(context, model);
    }

    void installRuntimeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String clientMappingsClusterName = EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_CLUSTER_NAME.resolveModelAttribute(context, model).asString();
        String connectorName = EJB3RemoteResourceDefinition.CONNECTOR_REF.resolveModelAttribute(context, model).asString();
        ServiceName remotingServerInfoServiceName = RemotingConnectorBindingInfoService.serviceName((String)connectorName);
        String threadPoolName = EJB3RemoteResourceDefinition.THREAD_POOL_NAME.resolveModelAttribute(context, model).asString();
        boolean executeInWorker = EJB3RemoteResourceDefinition.EXECUTE_IN_WORKER.resolveModelAttribute(context, model).asBoolean();
        ServiceTarget target = context.getServiceTarget();
        new EJBRemotingConnectorClientMappingsEntryProviderService(clientMappingsClusterName, remotingServerInfoServiceName).configure(context).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        new ClientMappingsRegistryBuilder(clientMappingsClusterName).configure(context).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        PathElement infinispanPath = PathElement.pathElement((String)"subsystem", (String)"infinispan");
        Resource infinispanResource = EJB3RemoteServiceAdd.safeGetResource(context, infinispanPath);
        if (infinispanResource == null || !infinispanResource.hasChild(PathElement.pathElement((String)"cache-container", (String)clientMappingsClusterName))) {
            CapabilityServiceSupport support = context.getCapabilityServiceSupport();
            for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(LocalGroupBuilderProvider.class, LocalGroupBuilderProvider.class.getClassLoader())) {
                for (CapabilityServiceBuilder builder : groupBuilderProvider.getBuilders(requirement -> requirement.getServiceName(support, clientMappingsClusterName), clientMappingsClusterName)) {
                    builder.configure(support).build(target).install();
                }
            }
            for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(LocalCacheBuilderProvider.class, LocalCacheBuilderProvider.class.getClassLoader())) {
                for (CapabilityServiceBuilder builder : cacheBuilderProvider.getBuilders(requirement -> requirement.getServiceName(support, clientMappingsClusterName, null), clientMappingsClusterName, null)) {
                    builder.configure(support).build(target).install();
                }
            }
        }
        OptionMap channelCreationOptions = this.getChannelCreationOptions(context);
        EJBRemoteConnectorService ejbRemoteConnectorService = new EJBRemoteConnectorService(channelCreationOptions);
        ServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(EJB3RemoteResourceDefinition.EJB_REMOTE_CAPABILITY, (Service)ejbRemoteConnectorService).addAliases(new ServiceName[]{EJBRemoteConnectorService.SERVICE_NAME}).addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, ejbRemoteConnectorService.getEndpointInjector()).addDependency(remotingServerInfoServiceName, RemotingConnectorBindingInfoService.RemotingConnectorInfo.class, ejbRemoteConnectorService.getRemotingConnectorInfoInjectedValue()).addDependency(AssociationService.SERVICE_NAME, AssociationService.class, ejbRemoteConnectorService.getAssociationServiceInjector()).addDependency(TxnServices.JBOSS_TXN_REMOTE_TRANSACTION_SERVICE, RemotingTransactionService.class, ejbRemoteConnectorService.getRemotingTransactionServiceInjector()).setInitialMode(ServiceController.Mode.LAZY);
        if (!executeInWorker) {
            serviceBuilder.addDependency(EJB3SubsystemModel.BASE_THREAD_POOL_SERVICE_NAME.append(new String[]{threadPoolName}), ExecutorService.class, ejbRemoteConnectorService.getExecutorService());
        }
        serviceBuilder.install();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_CLUSTER_NAME.validateAndSet(operation, model);
        EJB3RemoteResourceDefinition.CONNECTOR_REF.validateAndSet(operation, model);
        EJB3RemoteResourceDefinition.THREAD_POOL_NAME.validateAndSet(operation, model);
        EJB3RemoteResourceDefinition.EXECUTE_IN_WORKER.validateAndSet(operation, model);
    }

    private OptionMap getChannelCreationOptions(OperationContext context) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode channelCreationOptions = fullModel.get("channel-creation-options");
        if (channelCreationOptions.isDefined() && channelCreationOptions.asInt() > 0) {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            OptionMap.Builder builder = OptionMap.builder();
            for (Property optionProperty : channelCreationOptions.asPropertyList()) {
                String name = optionProperty.getName();
                ModelNode propValueModel = optionProperty.getValue();
                String type = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.resolveModelAttribute(context, propValueModel).asString();
                String optionClassName = this.getClassNameForChannelOptionType(type);
                String fullyQualifiedOptionName = optionClassName + "." + name;
                Option option = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)loader);
                String value = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.resolveModelAttribute(context, propValueModel).asString();
                builder.set(option, option.parseValue(value, loader));
            }
            return builder.getMap();
        }
        return OptionMap.EMPTY;
    }

    private String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(optionType);
    }

    private static Resource safeGetResource(OperationContext context, PathElement path) {
        try {
            return context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{path}), false);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

