/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.Attachments;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.ee.naming.JavaNamespaceSetup;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ApplicationContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName applicationContextServiceName = ContextNames.contextServiceNameOfApplication((String)moduleDescription.getApplicationName());
        NamingStoreService contextService = new NamingStoreService(true);
        serviceTarget.addService(applicationContextServiceName, (Service)contextService).install();
        ServiceName appNameServiceName = applicationContextServiceName.append(new String[]{"AppName"});
        BinderService applicationNameBinder = new BinderService("AppName");
        applicationNameBinder.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Object)moduleDescription.getApplicationName()));
        serviceTarget.addService(appNameServiceName, (Service)applicationNameBinder).addDependency(applicationContextServiceName, ServiceBasedNamingStore.class, (Injector)applicationNameBinder.getNamingStoreInjector()).install();
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES, (Object)appNameServiceName);
        deploymentUnit.putAttachment(Attachments.APPLICATION_CONTEXT_CONFIG, (Object)applicationContextServiceName);
        if (!deploymentUnit.hasAttachment(Attachments.JAVA_NAMESPACE_SETUP_ACTION)) {
            InjectedEENamespaceContextSelector selector = new InjectedEENamespaceContextSelector();
            phaseContext.requires(applicationContextServiceName, selector.getAppContextSupplier());
            phaseContext.requires(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, selector.getJbossContextSupplier());
            phaseContext.requires(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, selector.getExportedContextSupplier());
            phaseContext.requires(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, selector.getGlobalContextSupplier());
            deploymentUnit.putAttachment(Attachments.JAVA_NAMESPACE_SETUP_ACTION, (Object)new ApplicationContextProcessorJavaNamespaceSetup(selector, deploymentUnit.getServiceName()));
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        JavaNamespaceSetup action = (JavaNamespaceSetup)deploymentUnit.getAttachment(Attachments.JAVA_NAMESPACE_SETUP_ACTION);
        if (action != null && action instanceof ApplicationContextProcessorJavaNamespaceSetup) {
            deploymentUnit.removeAttachment(Attachments.JAVA_NAMESPACE_SETUP_ACTION);
        }
        deploymentUnit.removeAttachment(Attachments.APPLICATION_CONTEXT_CONFIG);
    }

    private static class ApplicationContextProcessorJavaNamespaceSetup
    extends JavaNamespaceSetup {
        ApplicationContextProcessorJavaNamespaceSetup(NamespaceContextSelector namespaceSelector, ServiceName deploymentUnitServiceName) {
            super(namespaceSelector, deploymentUnitServiceName);
        }
    }
}

