/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.managedbean.processors;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.ee.managedbean.component.ManagedBeanCreateInterceptor;
import org.jboss.as.ee.managedbean.component.ManagedBeanResourceReferenceProcessor;
import org.jboss.as.ee.structure.EJBAnnotationPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.AccessCheckingInterceptor;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;

public class ManagedBeanAnnotationProcessor
implements DeploymentUnitProcessor {
    static final DotName MANAGED_BEAN_ANNOTATION_NAME = DotName.createSimple((String)"jakarta.annotation.ManagedBean");
    private static final boolean HAS_MANAGED_BEAN;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        if (!HAS_MANAGED_BEAN) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEResourceReferenceProcessorRegistry registry = (EEResourceReferenceProcessorRegistry)deploymentUnit.getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        PropertyReplacer replacer = EJBAnnotationPropertyReplacement.propertyReplacer(deploymentUnit);
        if (compositeIndex == null) {
            return;
        }
        List instances = compositeIndex.getAnnotations(MANAGED_BEAN_ANNOTATION_NAME);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) {
                throw EeLogger.ROOT_LOGGER.classOnlyAnnotation("@ManagedBean", target);
            }
            ClassInfo classInfo = (ClassInfo)target;
            if (!ManagedBeanAnnotationProcessor.assertManagedBeanClassValidity(classInfo)) continue;
            String beanClassName = classInfo.name().toString();
            AnnotationValue nameValue = instance.value();
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? beanClassName : replacer.replaceProperties(nameValue.asString());
            ManagedBeanComponentDescription componentDescription = new ManagedBeanComponentDescription(beanName, beanClassName, moduleDescription, deploymentUnit.getServiceName());
            ViewDescription viewDescription = new ViewDescription(componentDescription, beanClassName);
            viewDescription.getConfigurators().addFirst(new ViewConfigurator(){

                @Override
                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) {
                    configuration.addClientPostConstructInterceptor(ManagedBeanCreateInterceptor.FACTORY, 256);
                    ClassLoader classLoader = componentConfiguration.getModuleClassLoader();
                    configuration.addViewInterceptor(AccessCheckingInterceptor.getFactory(), 1);
                    configuration.addViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor(classLoader)), 3);
                }
            });
            viewDescription.getBindingNames().addAll(Arrays.asList("java:module/" + beanName, "java:app/" + moduleDescription.getModuleName() + "/" + beanName));
            componentDescription.getViews().add(viewDescription);
            moduleDescription.addComponent(componentDescription);
            registry.registerResourceReferenceProcessor(new ManagedBeanResourceReferenceProcessor(beanClassName));
        }
    }

    private static boolean assertManagedBeanClassValidity(ClassInfo managedBeanClass) {
        short flags = managedBeanClass.flags();
        String className = managedBeanClass.name().toString();
        if (Modifier.isInterface(flags)) {
            EeLogger.ROOT_LOGGER.invalidManagedBeanInterface("MB.2.1.1", className);
            return false;
        }
        if (Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            EeLogger.ROOT_LOGGER.invalidManagedBeanAbstractOrFinal("MB.2.1.1", className);
            return false;
        }
        return true;
    }

    static {
        boolean hasManagedBean = false;
        try {
            ManagedBeanAnnotationProcessor.class.getClassLoader().loadClass("jakarta.annotation.ManagedBean");
            hasManagedBean = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_MANAGED_BEAN = hasManagedBean;
    }
}

