/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ManagedExecutorServiceMetricsHandler<T>
extends AbstractRuntimeOnlyHandler {
    private final Map<String, Metric<T>> metrics;
    private final RuntimeCapability capability;

    public static <T> Builder<T> builder(RuntimeCapability capability) {
        return new Builder(capability);
    }

    private ManagedExecutorServiceMetricsHandler(Map<String, Metric<T>> metrics, RuntimeCapability capability) {
        this.metrics = metrics;
        this.capability = capability;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (Metric<T> metric : this.metrics.values()) {
            registration.registerMetric(metric.attributeDefinition, (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String attributeName = operation.require("name").asString();
        if (context.getRunningMode() == RunningMode.NORMAL) {
            ServiceName serviceName = this.capability.getCapabilityServiceName(context.getCurrentAddress());
            ServiceController controller = context.getServiceRegistry(false).getService(serviceName);
            if (controller == null) {
                throw EeLogger.ROOT_LOGGER.executorServiceNotFoundForMetrics(serviceName);
            }
            Service service = controller.getService();
            Metric<T> metric = this.metrics.get(attributeName);
            if (metric == null) {
                throw EeLogger.ROOT_LOGGER.unsupportedExecutorServiceMetric(attributeName);
            }
            metric.resultSetter.setResult(context, service);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public static interface MetricResultSetter<T> {
        public void setResult(OperationContext var1, T var2) throws OperationFailedException;
    }

    private static class Metric<T> {
        final AttributeDefinition attributeDefinition;
        final MetricResultSetter<T> resultSetter;

        Metric(AttributeDefinition attributeDefinition, MetricResultSetter<T> resultSetter) {
            this.attributeDefinition = attributeDefinition;
            this.resultSetter = resultSetter;
        }
    }

    public static class Builder<T> {
        private final RuntimeCapability capability;
        private final Map<String, Metric<T>> metrics = new HashMap<String, Metric<T>>();

        public Builder(RuntimeCapability capability) {
            this.capability = capability;
        }

        public Builder<T> addMetric(AttributeDefinition attributeDefinition, MetricResultSetter<T> resultSetter) {
            String name = attributeDefinition.getName();
            this.metrics.put(name, new Metric<T>(attributeDefinition, resultSetter));
            return this;
        }

        public ManagedExecutorServiceMetricsHandler<T> build() {
            return new ManagedExecutorServiceMetricsHandler(Collections.unmodifiableMap(this.metrics), this.capability);
        }
    }
}

