/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.as.ee.subsystem.EeExtension;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceAdd;
import org.jboss.as.ee.subsystem.ManagedThreadFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ManagedExecutorServiceResourceDefinition
extends SimpleResourceDefinition {
    public static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ee.concurrent.executor", (boolean)true, ManagedExecutorServiceAdapter.class).build();
    public static final String JNDI_NAME = "jndi-name";
    public static final String CONTEXT_SERVICE = "context-service";
    public static final String THREAD_FACTORY = "thread-factory";
    public static final String HUNG_TASK_THRESHOLD = "hung-task-threshold";
    public static final String LONG_RUNNING_TASKS = "long-running-tasks";
    public static final String CORE_THREADS = "core-threads";
    public static final String MAX_THREADS = "max-threads";
    public static final String KEEPALIVE_TIME = "keepalive-time";
    public static final String QUEUE_LENGTH = "queue-length";
    public static final String REJECT_POLICY = "reject-policy";
    public static final SimpleAttributeDefinition JNDI_NAME_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition CONTEXT_SERVICE_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("context-service", ModelType.STRING, true).setAllowExpression(false)).setValidator((ParameterValidator)new StringLengthValidator(0, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference(ContextServiceResourceDefinition.CAPABILITY.getName(), CAPABILITY)).build();
    public static final SimpleAttributeDefinition THREAD_FACTORY_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("thread-factory", ModelType.STRING, true).setAllowExpression(false)).setValidator((ParameterValidator)new StringLengthValidator(0, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference(ManagedThreadFactoryResourceDefinition.CAPABILITY.getName(), CAPABILITY)).build();
    public static final SimpleAttributeDefinition HUNG_TASK_THRESHOLD_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hung-task-threshold", ModelType.LONG, true).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(0L, Long.MAX_VALUE, true, true))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setDefaultValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition LONG_RUNNING_TASKS_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("long-running-tasks", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition CORE_THREADS_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("core-threads", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition MAX_THREADS_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-threads", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition KEEPALIVE_TIME_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("keepalive-time", ModelType.LONG, true).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(0L, Long.MAX_VALUE, true, true))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(60000))).build();
    public static final SimpleAttributeDefinition QUEUE_LENGTH_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("queue-length", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition REJECT_POLICY_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("reject-policy", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(AbstractManagedExecutorService.RejectPolicy.ABORT.toString()))).setValidator((ParameterValidator)EnumValidator.create(AbstractManagedExecutorService.RejectPolicy.class, (boolean)true, (boolean)true))).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{JNDI_NAME_AD, CONTEXT_SERVICE_AD, THREAD_FACTORY_AD, HUNG_TASK_THRESHOLD_AD, LONG_RUNNING_TASKS_AD, CORE_THREADS_AD, MAX_THREADS_AD, KEEPALIVE_TIME_AD, QUEUE_LENGTH_AD, REJECT_POLICY_AD};
    public static final ManagedExecutorServiceResourceDefinition INSTANCE = new ManagedExecutorServiceResourceDefinition();

    private ManagedExecutorServiceResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"managed-executor-service"), EeExtension.getResourceDescriptionResolver("managed-executor-service")).setAddHandler((OperationStepHandler)ManagedExecutorServiceAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler((AbstractAddStepHandler)ManagedExecutorServiceAdd.INSTANCE)).addCapabilities(new RuntimeCapability[]{CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ValidatingWriteHandler writeHandler = new ValidatingWriteHandler((AttributeDefinition[])ATTRIBUTES);
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)writeHandler);
        }
    }

    void registerTransformers_4_0(ResourceTransformationDescriptionBuilder builder) {
        PathElement pathElement = this.getPathElement();
        ResourceTransformationDescriptionBuilder resourceBuilder = builder.addChildResource(pathElement);
        ((AttributeTransformationDescriptionBuilder)resourceBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{CORE_THREADS_AD})).end();
    }

    static class ExecutorQueueValidationStepHandler
    implements OperationStepHandler {
        static final ExecutorQueueValidationStepHandler MODEL_VALIDATION_INSTANCE = new ExecutorQueueValidationStepHandler(false);
        private final boolean isRuntimeStage;

        private ExecutorQueueValidationStepHandler(boolean isRuntimeStage) {
            this.isRuntimeStage = isRuntimeStage;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode queueLength;
            ModelNode maxThreads;
            ModelNode coreThreads;
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            if (this.isRuntimeStage) {
                coreThreads = CORE_THREADS_AD.resolveModelAttribute(context, model);
                maxThreads = MAX_THREADS_AD.resolveModelAttribute(context, model);
                queueLength = QUEUE_LENGTH_AD.resolveModelAttribute(context, model);
            } else {
                coreThreads = model.get(ManagedExecutorServiceResourceDefinition.CORE_THREADS);
                maxThreads = model.get(ManagedExecutorServiceResourceDefinition.MAX_THREADS);
                queueLength = model.get(ManagedExecutorServiceResourceDefinition.QUEUE_LENGTH);
            }
            if (coreThreads.getType() == ModelType.EXPRESSION || maxThreads.getType() == ModelType.EXPRESSION || queueLength.getType() == ModelType.EXPRESSION) {
                context.addStep((OperationStepHandler)new ExecutorQueueValidationStepHandler(true), OperationContext.Stage.RUNTIME, true);
                return;
            }
            if ((!queueLength.isDefined() || queueLength.asInt() == Integer.MAX_VALUE) && coreThreads.isDefined() && coreThreads.asInt() <= 0) {
                throw EeLogger.ROOT_LOGGER.invalidCoreThreadsSize(queueLength.asString());
            }
            if (queueLength.isDefined() && queueLength.asInt() == 0 && coreThreads.isDefined() && coreThreads.asInt() <= 0) {
                throw EeLogger.ROOT_LOGGER.invalidCoreThreadsSize(queueLength.asString());
            }
            if (coreThreads.isDefined() && coreThreads.asInt() == 0 && (!maxThreads.isDefined() || maxThreads.asInt() <= 0)) {
                throw EeLogger.ROOT_LOGGER.invalidMaxThreads(maxThreads.isDefined() ? maxThreads.asInt() : 0, coreThreads.asInt());
            }
            if (coreThreads.isDefined() && maxThreads.isDefined() && maxThreads.asInt() < coreThreads.asInt()) {
                throw EeLogger.ROOT_LOGGER.invalidMaxThreads(maxThreads.asInt(), coreThreads.asInt());
            }
        }
    }

    static class ValidatingWriteHandler
    extends ReloadRequiredWriteAttributeHandler {
        public ValidatingWriteHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
            context.addStep((OperationStepHandler)ExecutorQueueValidationStepHandler.MODEL_VALIDATION_INSTANCE, OperationContext.Stage.MODEL);
            super.validateUpdatedModel(context, model);
        }
    }
}

