/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;
import org.xnio.streams.ChannelInputStream;

class DomainApiHandler
implements HttpHandler {
    private final ModelController modelController;

    DomainApiHandler(ModelController modelController) {
        this.modelController = modelController;
    }

    public void handleRequest(final HttpServerExchange exchange) {
        ModelNode response;
        boolean cachable;
        ModelNode dmr;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        boolean get = exchange.getRequestMethod().equals(Methods.GET);
        final boolean encode = "application/dmr-encoded".equals(requestHeaders.getFirst(Headers.ACCEPT)) || "application/dmr-encoded".equals(requestHeaders.getFirst(Headers.CONTENT_TYPE));
        final OperationParameter.Builder operationParameterBuilder = new OperationParameter.Builder(get).encode(encode);
        try {
            if (get) {
                GetOperation operation = this.getOperation(exchange);
                operationParameterBuilder.maxAge(operation.getMaxAge());
                dmr = this.convertGetRequest(exchange, operation);
                cachable = operation.getMaxAge() > 0;
            } else {
                dmr = this.convertPostRequest(exchange, encode);
                cachable = false;
            }
            operationParameterBuilder.pretty(dmr.hasDefined("json.pretty") && dmr.get("json.pretty").asBoolean());
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debugf("Unable to construct ModelNode '%s'", e.getMessage());
            Common.sendError(exchange, false, e.getLocalizedMessage());
            return;
        }
        final ResponseCallback callback = new ResponseCallback(){

            @Override
            void doSendResponse(ModelNode response) {
                if (response.hasDefined("outcome") && "failed".equals(response.get("outcome").asString())) {
                    Common.sendError(exchange, encode, response);
                    return;
                }
                DomainUtil.writeResponse(exchange, 200, response, operationParameterBuilder.build());
            }
        };
        boolean sendPreparedResponse = this.sendPreparedResponse(dmr);
        ModelController.OperationTransactionControl control = sendPreparedResponse ? new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                transaction.commit();
                result.get("outcome").set("success");
                result.get("result");
                callback.sendResponse(result);
            }
        } : ModelController.OperationTransactionControl.COMMIT;
        try {
            dmr.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.HTTP.toString());
            response = this.modelController.execute(dmr, OperationMessageHandler.logging, control, (OperationAttachments)new OperationBuilder(dmr).build());
            if (cachable) {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(response.toString().getBytes());
                ETag etag = new ETag(false, HexConverter.convertToHexString((byte[])md.digest()));
                operationParameterBuilder.etag(etag);
                if (!ETagUtils.handleIfNoneMatch((HttpServerExchange)exchange, (ETag)etag, (boolean)false)) {
                    exchange.setResponseCode(304);
                    DomainUtil.writeCacheHeaders(exchange, 304, operationParameterBuilder.build());
                    exchange.endExchange();
                    return;
                }
            }
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.modelRequestError(t);
            Common.sendError(exchange, encode, t.getLocalizedMessage());
            return;
        }
        callback.sendResponse(response);
    }

    private GetOperation getOperation(HttpServerExchange exchange) {
        Map queryParameters = exchange.getQueryParameters();
        GetOperation operation = null;
        Deque parameter = (Deque)queryParameters.get("operation");
        if (parameter != null) {
            String value = (String)parameter.getFirst();
            try {
                operation = GetOperation.valueOf(value.toUpperCase(Locale.ENGLISH).replace('-', '_'));
                value = operation.realOperation();
            }
            catch (Exception e) {
                throw HttpServerMessages.MESSAGES.invalidOperation(e, value);
            }
        }
        if (operation == null) {
            operation = GetOperation.RESOURCE;
        }
        return operation;
    }

    private ModelNode convertGetRequest(HttpServerExchange exchange, GetOperation operation) {
        ArrayList<String> pathSegments = this.decodePath(exchange.getRequestPath());
        Map queryParameters = exchange.getQueryParameters();
        ModelNode dmr = new ModelNode();
        for (Map.Entry entry : queryParameters.entrySet()) {
            ModelNode valueNode;
            String key = (String)entry.getKey();
            String value = (String)((Deque)entry.getValue()).getFirst();
            if (key.startsWith("operation-header-")) {
                String header = key.substring("operation-header-".length());
                valueNode = dmr.get(new String[]{"operation-headers", header});
            } else {
                valueNode = dmr.get(key);
            }
            valueNode.set(!value.equals("") ? value : "true");
        }
        dmr.get("operation").set(operation.realOperation);
        ModelNode list = dmr.get("address").setEmptyList();
        for (int i = 1; i < pathSegments.size() - 1; i += 2) {
            list.add(pathSegments.get(i), pathSegments.get(i + 1));
        }
        return dmr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode convertPostRequest(HttpServerExchange exchange, boolean encode) throws IOException {
        ChannelInputStream in = new ChannelInputStream(exchange.getRequestChannel());
        try {
            ModelNode modelNode = encode ? ModelNode.fromBase64((InputStream)in) : ModelNode.fromJSONStream((InputStream)in);
            return modelNode;
        }
        finally {
            IoUtils.safeClose((Closeable)in);
        }
    }

    private ArrayList<String> decodePath(String path) {
        int j;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        int i = path.charAt(0) == '/' ? 1 : 0;
        ArrayList<String> segments = new ArrayList<String>();
        do {
            if ((j = path.indexOf(47, i)) == -1) {
                j = path.length();
            }
            segments.add(this.unescape(path.substring(i, j)));
        } while ((i = j + 1) < path.length());
        return segments;
    }

    private String unescape(String string) {
        try {
            return URLDecoder.decode(string, Common.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String op = operation.get("operation").asString();
        int size = address.size();
        if (size == 0) {
            if (op.equals("reload")) {
                return true;
            }
            if (op.equals("composite")) {
                return false;
            }
            return false;
        }
        if (size == 1 && address.getLastElement().getKey().equals("host")) {
            return op.equals("reload");
        }
        return false;
    }

    private static abstract class ResponseCallback {
        private volatile boolean complete;

        private ResponseCallback() {
        }

        void sendResponse(ModelNode response) {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.doSendResponse(response);
        }

        abstract void doSendResponse(ModelNode var1);
    }

    static enum GetOperation {
        RESOURCE("read-resource", 0),
        ATTRIBUTE("read-attribute", 0),
        RESOURCE_DESCRIPTION("read-resource-description", 604800),
        SNAPSHOTS("list-snapshots", 0),
        OPERATION_DESCRIPTION("read-operation-description", 604800),
        OPERATION_NAMES("read-operation-names", 0);

        private String realOperation;
        private int maxAge;

        private GetOperation(String realOperation, int maxAge) {
            this.realOperation = realOperation;
            this.maxAge = maxAge;
        }

        public String realOperation() {
            return this.realOperation;
        }

        public int getMaxAge() {
            return this.maxAge;
        }
    }
}

