/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.util.AttachmentKey;

public class ConnectionAuthenticationCacheHandler
implements HttpHandler {
    AttachmentKey<AuthenticatedSessionManager.AuthenticatedSession> SESSION_KEY = AttachmentKey.create(AuthenticatedSessionManager.AuthenticatedSession.class);
    private final NotificationReceiver NOTIFICATION_HANDLER = new SecurityNotificationHandler();
    private final AuthenticatedSessionManager SESSION_MANAGER = new DigestAuthenticatedSessionManager();
    private final HttpHandler next;

    public ConnectionAuthenticationCacheHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext securityContext = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        securityContext.registerNotificationReceiver(this.NOTIFICATION_HANDLER);
        exchange.putAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY, (Object)this.SESSION_MANAGER);
        this.next.handleRequest(exchange);
    }

    private class DigestAuthenticatedSessionManager
    implements AuthenticatedSessionManager {
        private DigestAuthenticatedSessionManager() {
        }

        public AuthenticatedSessionManager.AuthenticatedSession lookupSession(HttpServerExchange exchange) {
            ServerConnection connection = exchange.getConnection();
            return (AuthenticatedSessionManager.AuthenticatedSession)connection.getAttachment(ConnectionAuthenticationCacheHandler.this.SESSION_KEY);
        }
    }

    private class SecurityNotificationHandler
    implements NotificationReceiver {
        private SecurityNotificationHandler() {
        }

        public void handleNotification(SecurityNotification notification) {
            SecurityNotification.EventType eventType = notification.getEventType();
            switch (eventType) {
                case AUTHENTICATED: {
                    ServerConnection connection = notification.getExchange().getConnection();
                    connection.putAttachment(ConnectionAuthenticationCacheHandler.this.SESSION_KEY, (Object)new AuthenticatedSessionManager.AuthenticatedSession(notification.getAccount(), notification.getMechanism()));
                    break;
                }
                case LOGGED_OUT: {
                    ServerConnection connection = notification.getExchange().getConnection();
                    connection.removeAttachment(ConnectionAuthenticationCacheHandler.this.SESSION_KEY);
                    break;
                }
            }
        }
    }
}

