/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.util.HexConverter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.security.SubjectAccount;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class RealmIdentityManager
implements IdentityManager {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final ThreadLocal<AuthMechanism> currentMechanism = new ThreadLocal();
    private final SecurityRealm securityRealm;

    static void setAuthenticationMechanism(AuthMechanism mechanism) {
        currentMechanism.set(mechanism);
    }

    public RealmIdentityManager(SecurityRealm securityRealm) {
        this.securityRealm = securityRealm;
    }

    public Account verify(Account account) {
        return account;
    }

    private boolean plainTextDigest() {
        Map mechConfig = this.securityRealm.getMechanismConfig(AuthMechanism.DIGEST);
        boolean plainTextDigest = true;
        if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
            plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
        }
        return plainTextDigest;
    }

    public Account verify(String id, Credential credential) {
        if (credential instanceof PasswordCredential) {
            return this.verify(id, (PasswordCredential)credential);
        }
        if (credential instanceof DigestCredential) {
            return this.verify(id, (DigestCredential)credential);
        }
        throw HttpServerMessages.MESSAGES.invalidCredentialType(credential.getClass().getName());
    }

    private Account verify(String id, PasswordCredential credential) {
        SubjectUserInfo supplemental;
        RealmIdentityManager.assertMechanism(AuthMechanism.PLAIN);
        if (!(credential instanceof PasswordCredential)) {
            return null;
        }
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN);
        Callback[] callbacks = new Callback[]{new RealmCallback("Realm", this.securityRealm.getName()), new NameCallback("Username", id), new VerifyPasswordCallback(new String(credential.getPassword()))};
        try {
            ach.handle(callbacks);
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debug("Failure handling Callback(s) for BASIC authentication.", e);
            return null;
        }
        if (!((VerifyPasswordCallback)callbacks[2]).isVerified()) {
            return null;
        }
        SimplePrincipal user = new SimplePrincipal(id);
        Set<SimplePrincipal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        return new RealmIdentityAccount(supplemental.getSubject(), user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account verify(String id, DigestCredential credential) {
        byte[] ha1;
        RealmIdentityManager.assertMechanism(AuthMechanism.DIGEST);
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST);
        Callback[] callbacks = new Callback[3];
        callbacks[0] = new RealmCallback("Realm", credential.getRealm());
        callbacks[1] = new NameCallback("Username", id);
        boolean plainText = this.plainTextDigest();
        callbacks[2] = plainText ? new PasswordCallback("Password", false) : new DigestHashCallback("Digest");
        try {
            ach.handle(callbacks);
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debug("Failure handling Callback(s) for BASIC authentication.", e);
            return null;
        }
        if (plainText) {
            MessageDigest digest = null;
            try {
                digest = credential.getAlgorithm().getMessageDigest();
                digest.update(id.getBytes(UTF_8));
                digest.update((byte)58);
                digest.update(credential.getRealm().getBytes(UTF_8));
                digest.update((byte)58);
                digest.update(new String(((PasswordCallback)callbacks[2]).getPassword()).getBytes(UTF_8));
                ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
                Account account = null;
                return account;
            }
            finally {
                digest.reset();
            }
        } else {
            ha1 = ((DigestHashCallback)callbacks[2]).getHexHash().getBytes(UTF_8);
        }
        try {
            if (credential.verifyHA1(ha1)) {
                SimplePrincipal user = new SimplePrincipal(id);
                Set<SimplePrincipal> userCol = Collections.singleton(user);
                SubjectUserInfo supplemental = ach.createSubjectUserInfo(userCol);
                return new RealmIdentityAccount(supplemental.getSubject(), user);
            }
        }
        catch (IOException e) {
            HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
        }
        return null;
    }

    public Account verify(Credential credential) {
        SubjectUserInfo supplemental;
        RealmIdentityManager.assertMechanism(AuthMechanism.CLIENT_CERT);
        if (!(credential instanceof X509CertificateCredential)) {
            return null;
        }
        X509CertificateCredential certCred = (X509CertificateCredential)credential;
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT);
        Principal user = certCred.getCertificate().getSubjectDN();
        Set<Principal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        return new RealmIdentityAccount(supplemental.getSubject(), user);
    }

    private static void assertMechanism(AuthMechanism mechanism) {
        if (mechanism != currentMechanism.get()) {
            throw new IllegalStateException("Unexpected authentication mechanism executing.");
        }
    }

    private class RealmIdentityAccount
    implements SubjectAccount {
        private final Subject subject;
        private final Principal principal;

        private RealmIdentityAccount(Subject subject, Principal principal) {
            this.subject = subject;
            this.principal = principal;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        @Override
        public Subject getSubject() {
            return this.subject;
        }
    }

    private class SimplePrincipal
    implements Principal {
        private final String name;

        private SimplePrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

