/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.io.IoCallback;
import io.undertow.security.api.NonceManager;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

public class LogoutHandler
implements HttpHandler {
    public static final String PATH = "/logout";
    private final DigestAuthenticationMechanism digestMechanism;
    private final DigestAuthenticationMechanism fakeRealmdigestMechanism;

    public LogoutHandler(String realmName) {
        List<DigestAlgorithm> digestAlgorithms = Collections.singletonList(DigestAlgorithm.MD5);
        List digestQops = Collections.emptyList();
        this.digestMechanism = new DigestAuthenticationMechanism(digestAlgorithms, digestQops, realmName, "/management", (NonceManager)new SimpleNonceManager());
        this.fakeRealmdigestMechanism = new DigestAuthenticationMechanism(digestAlgorithms, digestQops, "HIT THE ESCAPE KEY", "/management", (NonceManager)new SimpleNonceManager());
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        String authorization = requestHeaders.getFirst(Headers.AUTHORIZATION);
        String rawQuery = exchange.getQueryString();
        boolean query = rawQuery != null && rawQuery.contains("logout");
        String userAgent = requestHeaders.getFirst(Headers.USER_AGENT);
        boolean opera = userAgent != null && userAgent.contains("Opera");
        boolean win = !opera && userAgent != null && userAgent.contains("MSIE");
        String referrer = responseHeaders.getFirst(Headers.REFERER);
        String protocol = "http";
        String host = null;
        if (referrer != null) {
            try {
                URI uri = new URI(referrer);
                protocol = uri.getScheme();
                host = uri.getHost() + (uri.getPort() == -1 ? "" : ":" + String.valueOf(uri.getPort()));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (host == null && (host = requestHeaders.getFirst(Headers.HOST)) == null) {
            exchange.setResponseCode(500);
            return;
        }
        if (!(win || authorization != null && authorization.contains("enter-login-here"))) {
            if (!query) {
                responseHeaders.add(Headers.LOCATION, protocol + "://enter-login-here:blah@" + host + "/logout?logout");
                exchange.setResponseCode(307);
                return;
            }
            DigestAuthenticationMechanism mech = opera ? this.fakeRealmdigestMechanism : this.digestMechanism;
            mech.sendChallenge(exchange, null);
            String reply = "<html><script type='text/javascript'>window.location=\"" + protocol + "://" + host + "/\";</script></html>";
            exchange.setResponseCode(401);
            exchange.getResponseSender().send(reply, IoCallback.END_EXCHANGE);
            return;
        }
        responseHeaders.add(Headers.LOCATION, protocol + "://" + host + "/");
        exchange.setResponseCode(307);
    }
}

