/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.service.CMResourceService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.subsystem.CMResourceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;

class CMResourceAdd
extends AbstractAddStepHandler {
    static CMResourceAdd INSTANCE = new CMResourceAdd();

    CMResourceAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String str = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        if (!str.startsWith("java:/") && !str.startsWith("java:jboss/")) {
            throw TransactionLogger.ROOT_LOGGER.jndiNameInvalidFormat();
        }
        CMResourceResourceDefinition.CM_TABLE_NAME.validateAndSet(operation, model);
        CMResourceResourceDefinition.CM_TABLE_BATCH_SIZE.validateAndSet(operation, model);
        CMResourceResourceDefinition.CM_TABLE_IMMEDIATE_CLEANUP.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (!context.isBooting()) {
            context.restartRequired();
            return;
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String jndiName = address.getLastElement().getValue();
        String tableName = CMResourceResourceDefinition.CM_TABLE_NAME.resolveModelAttribute(context, model).asString();
        int batchSize = CMResourceResourceDefinition.CM_TABLE_BATCH_SIZE.resolveModelAttribute(context, model).asInt();
        boolean immediateCleanup = CMResourceResourceDefinition.CM_TABLE_IMMEDIATE_CLEANUP.resolveModelAttribute(context, model).asBoolean();
        TransactionLogger.ROOT_LOGGER.debugf("adding commit-markable-resource: jndi-name=%s, table-name=%s, batch-size=%d, immediate-cleanup=%b", new Object[]{jndiName, tableName, batchSize, immediateCleanup});
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addService();
        Consumer serviceConsumer = sb.provides(new ServiceName[]{TxnServices.JBOSS_TXN_CMR.append(new String[]{jndiName})});
        Supplier jtaEnvironmentBeanSupplier = sb.requires(TxnServices.JBOSS_TXN_JTA_ENVIRONMENT);
        CMResourceService service = new CMResourceService(serviceConsumer, jtaEnvironmentBeanSupplier, jndiName, tableName, immediateCleanup, batchSize);
        sb.setInstance((Service)service).install();
    }
}

