/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.management.ObjectName;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.creation.ValueConverter;
import org.jberet.job.model.Properties;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchBeanProducer {
    @Produces
    public JobContext getJobContext() {
        return ArtifactCreationContext.getCurrentArtifactCreationContext().jobContext;
    }

    @Produces
    public StepContext getStepContext() {
        return ArtifactCreationContext.getCurrentArtifactCreationContext().stepContext;
    }

    @Produces
    @BatchProperty
    public Integer getInt(InjectionPoint injectionPoint) {
        Integer i = this.getProperty(injectionPoint, Integer.class);
        if (i == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return 0;
        }
        return i;
    }

    @Produces
    @BatchProperty
    public int[] getIntArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, int[].class);
    }

    @Produces
    @BatchProperty
    public Integer[] getIntegerArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Integer[].class);
    }

    @Produces
    @BatchProperty
    public Long getLong(InjectionPoint injectionPoint) {
        Long l = this.getProperty(injectionPoint, Long.class);
        if (l == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return 0L;
        }
        return l;
    }

    @Produces
    @BatchProperty
    public Long[] getBigLongArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Long[].class);
    }

    @Produces
    @BatchProperty
    public long[] getLongArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, long[].class);
    }

    @Produces
    @BatchProperty
    public Short getShort(InjectionPoint injectionPoint) {
        Short sh = this.getProperty(injectionPoint, Short.class);
        if (sh == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return (short)0;
        }
        return sh;
    }

    @Produces
    @BatchProperty
    public Short[] getBigShortArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Short[].class);
    }

    @Produces
    @BatchProperty
    public short[] getShortArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, short[].class);
    }

    @Produces
    @BatchProperty
    public Byte getByte(InjectionPoint injectionPoint) {
        Byte b = this.getProperty(injectionPoint, Byte.class);
        if (b == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return (byte)0;
        }
        return b;
    }

    @Produces
    @BatchProperty
    public Byte[] getBigByteArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Byte[].class);
    }

    @Produces
    @BatchProperty
    public byte[] getByteArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, byte[].class);
    }

    @Produces
    @BatchProperty
    public Character getCharacter(InjectionPoint injectionPoint) {
        Character ch = this.getProperty(injectionPoint, Character.class);
        if (ch == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return Character.valueOf('\u0000');
        }
        return ch;
    }

    @Produces
    @BatchProperty
    public Character[] getCharacterArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Character[].class);
    }

    @Produces
    @BatchProperty
    public char[] getCharArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, char[].class);
    }

    @Produces
    @BatchProperty
    public Float getFloat(InjectionPoint injectionPoint) {
        Float f = this.getProperty(injectionPoint, Float.class);
        if (f == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return Float.valueOf(0.0f);
        }
        return f;
    }

    @Produces
    @BatchProperty
    public Float[] getBigFloatArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Float[].class);
    }

    @Produces
    @BatchProperty
    public float[] getFloatArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, float[].class);
    }

    @Produces
    @BatchProperty
    public Double getDouble(InjectionPoint injectionPoint) {
        Double d = this.getProperty(injectionPoint, Double.class);
        if (d == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return 0.0;
        }
        return d;
    }

    @Produces
    @BatchProperty
    public Double[] getBigDoubleArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Double[].class);
    }

    @Produces
    @BatchProperty
    public double[] getDoubleArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, double[].class);
    }

    @Produces
    @BatchProperty
    public Boolean getBoolean(InjectionPoint injectionPoint) {
        Boolean b = this.getProperty(injectionPoint, Boolean.class);
        if (b == null && BatchBeanProducer.isPrimitive(injectionPoint)) {
            return Boolean.FALSE;
        }
        return b;
    }

    @Produces
    @BatchProperty
    public Boolean[] getBigBooleanArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Boolean[].class);
    }

    @Produces
    @BatchProperty
    public boolean[] getBooleanArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, boolean[].class);
    }

    @Produces
    @BatchProperty
    public String getString(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, String.class);
    }

    @Produces
    @BatchProperty
    public String[] getStringArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, String[].class);
    }

    @Produces
    @BatchProperty
    public Date getDate(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Date.class);
    }

    @Produces
    @BatchProperty
    public Date[] getDateArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Date[].class);
    }

    @Produces
    @BatchProperty
    public Class getClazz(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Class.class);
    }

    @Produces
    @BatchProperty
    public Class[] getClazzArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Class[].class);
    }

    @Produces
    @BatchProperty
    public Inet4Address getInet4Address(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Inet4Address.class);
    }

    @Produces
    @BatchProperty
    public Inet6Address getInet6Address(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Inet6Address.class);
    }

    @Produces
    @BatchProperty
    public Map getMap(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Map.class);
    }

    @Produces
    @BatchProperty
    public Map<String, String> getStringMap(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Map.class);
    }

    @Produces
    @BatchProperty
    public Set getSet(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Set.class);
    }

    @Produces
    @BatchProperty
    public Set<String> getStringSet(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Set.class);
    }

    @Produces
    @BatchProperty
    public Logger getLogger(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Logger.class);
    }

    @Produces
    @BatchProperty
    public Pattern getPattern(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, Pattern.class);
    }

    @Produces
    @BatchProperty
    public ObjectName getObjectName(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, ObjectName.class);
    }

    @Produces
    @BatchProperty
    public List getList(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, List.class);
    }

    @Produces
    @BatchProperty
    public List<String> getStringList(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, List.class);
    }

    @Produces
    @BatchProperty
    public BigInteger getBigInteger(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, BigInteger.class);
    }

    @Produces
    @BatchProperty
    public BigInteger[] getBigIntegerArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, BigInteger[].class);
    }

    @Produces
    @BatchProperty
    public BigDecimal getBigDecimal(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, BigDecimal.class);
    }

    @Produces
    @BatchProperty
    public BigDecimal[] getBigDecimalArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, BigDecimal[].class);
    }

    @Produces
    @BatchProperty
    public URL getURL(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, URL.class);
    }

    @Produces
    @BatchProperty
    public URL[] getURLArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, URL[].class);
    }

    @Produces
    @BatchProperty
    public URI getURI(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, URI.class);
    }

    @Produces
    @BatchProperty
    public URI[] getURIArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, URI[].class);
    }

    @Produces
    @BatchProperty
    public File getFile(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, File.class);
    }

    @Produces
    @BatchProperty
    public File[] getFileArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, File[].class);
    }

    @Produces
    @BatchProperty
    public ZipFile[] getZipFileArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, ZipFile[].class);
    }

    @Produces
    @BatchProperty
    public JarFile getJarFile(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, JarFile.class);
    }

    @Produces
    @BatchProperty
    public JarFile[] getJarFileArray(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, JarFile[].class);
    }

    @Produces
    @BatchProperty
    public StringBuilder getStringBuilder(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, StringBuilder.class);
    }

    @Produces
    @BatchProperty
    public StringBuffer getStringBuffer(InjectionPoint injectionPoint) {
        return this.getProperty(injectionPoint, StringBuffer.class);
    }

    private static boolean isPrimitive(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        if (member != null) {
            if (member instanceof Field) {
                return ((Field)member).getType().isPrimitive();
            }
            Annotated annotated = injectionPoint.getAnnotated();
            if (annotated != null && annotated instanceof AnnotatedParameter) {
                return ((AnnotatedParameter)annotated).getJavaParameter().getType().isPrimitive();
            }
        }
        return false;
    }

    private <T> T getProperty(InjectionPoint injectionPoint, Class<T> injectionValueType) {
        AnnotatedElement paramOfField;
        String rawVal;
        ArtifactCreationContext ac = ArtifactCreationContext.getCurrentArtifactCreationContext();
        Properties properties = ac.properties;
        Annotated annotated = injectionPoint.getAnnotated();
        Member injectionTarget = injectionPoint.getMember();
        if (annotated == null) {
            Set qualifiers = injectionPoint.getQualifiers();
            for (Annotation ann : qualifiers) {
                if (!(ann instanceof BatchProperty)) continue;
                BatchProperty batchProperty = (BatchProperty)ann;
                String propName = batchProperty.name();
                if (propName.isEmpty()) {
                    throw BatchMessages.MESSAGES.batchPropertyNameMissing(injectionTarget);
                }
                return (T)(properties == null ? null : properties.get(propName));
            }
            return null;
        }
        BatchProperty batchProperty = (BatchProperty)annotated.getAnnotation(BatchProperty.class);
        String propName = batchProperty.name();
        if (annotated instanceof AnnotatedParameter) {
            if (propName.isEmpty()) {
                throw BatchMessages.MESSAGES.batchPropertyNameMissing(injectionTarget);
            }
            rawVal = properties == null ? null : properties.get(propName);
            paramOfField = ((AnnotatedParameter)annotated).getJavaParameter();
        } else {
            Field field;
            paramOfField = field = (Field)injectionTarget;
            if (propName.length() == 0) {
                propName = field.getName();
            }
            String string = rawVal = properties == null ? null : properties.get(propName);
            if (rawVal == null) {
                try {
                    Object fieldVal;
                    Class beanClass = injectionPoint.getBean().getBeanClass();
                    final Object o = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (WildFlySecurityManager.isChecking()) {
                        fieldVal = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                if (!field.isAccessible()) {
                                    field.setAccessible(true);
                                }
                                return field.get(o);
                            }
                        });
                    } else {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        fieldVal = field.get(o);
                    }
                    return (T)fieldVal;
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.tracef(e, "Failed to get the default value for undefined batch property %s, will use null.", propName);
                    return null;
                }
            }
        }
        if (rawVal == null || rawVal.isEmpty()) {
            return null;
        }
        return (T)(injectionValueType.isAssignableFrom(String.class) ? rawVal : ValueConverter.convertInjectionValue(rawVal, injectionValueType, paramOfField, ac.jobContext.getClassLoader()));
    }
}

