/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.coordinator;

import java.util.Arrays;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.extension.microprofile.lra.coordinator.MicroProfileLRACoordinatorSubsystemDefinition;
import org.wildfly.extension.microprofile.lra.coordinator._private.MicroProfileLRACoordinatorLogger;
import org.wildfly.extension.microprofile.lra.coordinator.service.LRACoordinatorService;
import org.wildfly.extension.microprofile.lra.coordinator.service.LRARecoveryService;
import org.wildfly.extension.undertow.Capabilities;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

class MicroProfileLRACoordinatorAdd
extends AbstractBoottimeAddStepHandler {
    MicroProfileLRACoordinatorAdd() {
        super(Arrays.asList(MicroProfileLRACoordinatorSubsystemDefinition.ATTRIBUTES));
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        this.registerRecoveryService(context);
        this.registerCoordinatorService(context, model);
        MicroProfileLRACoordinatorLogger.LOGGER.activatingSubsystem();
    }

    private void registerCoordinatorService(OperationContext context, ModelNode model) throws OperationFailedException {
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(MicroProfileLRACoordinatorSubsystemDefinition.LRA_COORDINATOR_CAPABILITY);
        builder.requiresCapability("org.wildfly.undertow", UndertowService.class, new String[0]);
        String serverModelValue = MicroProfileLRACoordinatorSubsystemDefinition.SERVER.resolveModelAttribute(context, model).asString();
        String hostModelValue = MicroProfileLRACoordinatorSubsystemDefinition.HOST.resolveModelAttribute(context, model).asString();
        Supplier hostSupplier = builder.requiresCapability(Capabilities.CAPABILITY_HOST, Host.class, new String[]{serverModelValue, hostModelValue});
        LRACoordinatorService lraCoordinatorService = new LRACoordinatorService(hostSupplier);
        builder.requiresCapability("org.wildfly.microprofile.lra.recovery", null, new String[0]);
        builder.setInstance((Service)lraCoordinatorService);
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerRecoveryService(OperationContext context) {
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(MicroProfileLRACoordinatorSubsystemDefinition.LRA_RECOVERY_SERVICE_CAPABILITY);
        builder.provides(MicroProfileLRACoordinatorSubsystemDefinition.LRA_RECOVERY_SERVICE_CAPABILITY);
        builder.requiresCapability("org.wildfly.transactions.xa-resource-recovery-registry", XAResourceRecoveryRegistry.class, new String[0]);
        Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)builder);
        LRARecoveryService lraRecoveryService = new LRARecoveryService(executorSupplier);
        builder.setInstance((Service)lraRecoveryService);
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

