/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.marshalling.SimpleDataOutput;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.AbstractByteBufferMarshaller;
import org.wildfly.clustering.marshalling.IndexSerializer;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;

public class JBossByteBufferMarshaller
extends AbstractByteBufferMarshaller {
    private final MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader());
    private final MarshallingConfigurationRepository repository;
    private final MarshallingConfiguration configuration;

    public JBossByteBufferMarshaller(MarshallingConfigurationRepository repository, ClassLoader loader) {
        this(repository, repository.getCurrentMarshallingConfiguration(), loader);
    }

    public JBossByteBufferMarshaller(MarshallingConfiguration configuration, ClassLoader loader) {
        this(null, configuration, loader);
    }

    private JBossByteBufferMarshaller(MarshallingConfigurationRepository repository, MarshallingConfiguration configuration, ClassLoader loader) {
        super(loader);
        this.repository = repository;
        this.configuration = configuration;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object readFrom(InputStream input) throws IOException {
        try (SimpleDataInput data = new SimpleDataInput(Marshalling.createByteInput((InputStream)input));){
            Object object;
            block15: {
                MarshallingConfiguration configuration = this.configuration;
                if (this.repository != null) {
                    int version = IndexSerializer.UNSIGNED_BYTE.readInt((DataInput)data);
                    configuration = this.repository.getMarshallingConfiguration(version);
                }
                Unmarshaller unmarshaller = this.factory.createUnmarshaller(configuration);
                try {
                    unmarshaller.start((ByteInput)data);
                    Object result = unmarshaller.readObject();
                    unmarshaller.finish();
                    object = result;
                    if (unmarshaller == null) break block15;
                }
                catch (Throwable throwable) {
                    if (unmarshaller != null) {
                        try {
                            unmarshaller.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                unmarshaller.close();
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            InvalidClassException exception = new InvalidClassException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        catch (RuntimeException e) {
            InvalidObjectException exception = new InvalidObjectException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public void writeTo(OutputStream output, Object value) throws IOException {
        try (SimpleDataOutput data = new SimpleDataOutput(Marshalling.createByteOutput((OutputStream)output));){
            if (this.repository != null) {
                IndexSerializer.UNSIGNED_BYTE.writeInt((DataOutput)data, this.repository.getCurrentVersion());
            }
            try (Marshaller marshaller = this.factory.createMarshaller(this.configuration);){
                marshaller.start((ByteOutput)data);
                marshaller.writeObject(value);
                marshaller.finish();
            }
        }
    }

    public boolean test(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> objectClass = object.getClass();
        try {
            if (this.configuration.getObjectTable().getObjectWriter(object) != null) {
                return true;
            }
            if (this.configuration.getClassExternalizerFactory().getExternalizer(objectClass) != null) {
                return true;
            }
            return this.configuration.getSerializabilityChecker().isSerializable(objectClass);
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return "JBossMarshalling";
    }
}

