/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.wiring;

import io.smallrye.reactive.messaging.providers.wiring.Wiring;
import io.smallrye.reactive.messaging.providers.wiring.WiringException;

public class TooManyDownstreamCandidatesException
extends WiringException {
    private final Wiring.PublishingComponent component;

    public TooManyDownstreamCandidatesException(Wiring.PublishingComponent pc) {
        this.component = pc;
    }

    public String getMessage() {
        return String.format("'%s' supports a single downstream consumer, but found %d: %s. You may want to enable broadcast using %s", this.component, this.component.downstreams().size(), this.component.downstreams(), this.getHint());
    }

    private String getHint() {
        if (this.component instanceof Wiring.InboundConnectorComponent) {
            return "'mp.messaging.incoming." + this.component.getOutgoingChannel() + ".broadcast=true' + to allow multiple downstreams.";
        }
        if (this.component instanceof Wiring.EmitterComponent) {
            return "'@Broadcast' on the injected emitter field.";
        }
        if (this.component instanceof Wiring.PublisherMediatorComponent || this.component instanceof Wiring.ProcessorMediatorComponent) {
            return "'@Broadcast' on the method " + String.valueOf(this.component) + ".";
        }
        throw new IllegalStateException("Unable to provide the broadcast hint " + String.valueOf(this.component));
    }
}

