/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.PausableChannel;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class PausableMulti<T>
extends MultiOperator<T, T>
implements PausableChannel {
    private volatile boolean paused;
    volatile PausableProcessor processor;
    private final ReentrantLock lock = new ReentrantLock();

    public PausableMulti(Multi<T> upstream, boolean paused) {
        super(upstream);
        this.paused = paused;
    }

    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.processor = new PausableProcessor(subscriber);
        this.upstream().subscribe((Flow.Subscriber)((Object)this.processor));
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.lock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resume() {
        this.lock.lock();
        try {
            PausableProcessor p;
            if (this.paused && (p = this.processor) != null) {
                this.paused = false;
                p.resume();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class PausableProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicLong demand;

        PausableProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.demand = new AtomicLong();
        }

        void resume() {
            Flow.Subscription subscription = this.getUpstreamSubscription();
            if (subscription == Subscriptions.CANCELLED) {
                return;
            }
            long currentDemand = this.demand.get();
            if (currentDemand > 0L) {
                Subscriptions.produced((AtomicLong)this.demand, (long)currentDemand);
                subscription.request(currentDemand);
            }
        }

        public void request(long numberOfItems) {
            if (numberOfItems <= 0L) {
                this.onFailure(Subscriptions.getInvalidRequestException());
                return;
            }
            Flow.Subscription subscription = this.getUpstreamSubscription();
            if (subscription == Subscriptions.CANCELLED) {
                return;
            }
            try {
                Subscriptions.add((AtomicLong)this.demand, (long)numberOfItems);
                long currentDemand = this.demand.get();
                if (PausableMulti.this.paused) {
                    return;
                }
                if (currentDemand > 0L) {
                    Subscriptions.produced((AtomicLong)this.demand, (long)currentDemand);
                    subscription.request(currentDemand);
                }
            }
            catch (Throwable failure) {
                this.onFailure(failure);
            }
        }

        public void cancel() {
            PausableMulti.this.processor = null;
            super.cancel();
        }
    }
}

