/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.connectors;

import java.time.Duration;

public class WorkerPoolConfig {
    private final Integer maxConcurrency;
    private final Duration shutdownTimeout;
    private final Duration shutdownCheckInterval;

    public WorkerPoolConfig(int maxConcurrency, int shutdownTimeoutMs, int shutdownCheckIntervalMs) {
        this(maxConcurrency, Duration.ofMillis(shutdownTimeoutMs), Duration.ofMillis(shutdownCheckIntervalMs));
    }

    public WorkerPoolConfig(int maxConcurrency, Duration shutdownTimeout, Duration shutdownCheckInterval) {
        this.maxConcurrency = maxConcurrency;
        this.shutdownTimeout = shutdownTimeout;
        this.shutdownCheckInterval = shutdownCheckInterval;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public Duration shutdownTimeout() {
        return this.shutdownTimeout;
    }

    public Duration shutdownCheckInterval() {
        return this.shutdownCheckInterval;
    }
}

