/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.connectors;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.vertx.mutiny.core.Vertx;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;

@ApplicationScoped
public class ExecutionHolder {
    private static final String REACTIVE_MESSAGING_VERTX_CDI_QUALIFIER = "mp.messaging.connector.vertx.cdi.identifier";
    private boolean internalVertxInstance = false;
    final Vertx vertx;

    public void terminate(@Observes(notifyObserver=Reception.IF_EXISTS) @Priority(value=200) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.internalVertxInstance) {
            this.vertx.close().await().indefinitely();
        }
    }

    public ExecutionHolder() {
        this.vertx = null;
    }

    public ExecutionHolder(Vertx vertx) {
        this.vertx = vertx;
        this.internalVertxInstance = true;
    }

    @Inject
    public ExecutionHolder(@Any Instance<Vertx> instanceOfVertx, Instance<Config> config) {
        Instance vertxInstance;
        String cdiQualifier = null;
        if (config != null && !config.isUnsatisfied()) {
            Config theConfig = (Config)config.get();
            cdiQualifier = theConfig.getConfigValue(REACTIVE_MESSAGING_VERTX_CDI_QUALIFIER).getValue();
        }
        if (cdiQualifier != null && !cdiQualifier.isEmpty()) {
            ProviderLogging.log.vertxFromCDIQualifier(cdiQualifier);
            vertxInstance = instanceOfVertx.select(new Annotation[]{Identifier.Literal.of((String)cdiQualifier)});
        } else {
            vertxInstance = instanceOfVertx.select(new Annotation[]{Default.Literal.INSTANCE});
        }
        if (vertxInstance == null || vertxInstance.isUnsatisfied()) {
            this.internalVertxInstance = true;
            this.vertx = Vertx.vertx();
            ProviderLogging.log.vertXInstanceCreated();
        } else {
            this.vertx = (Vertx)vertxInstance.get();
        }
    }

    public Vertx vertx() {
        return this.vertx;
    }

    boolean isInternalVertxInstance() {
        return this.internalVertxInstance;
    }
}

