/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.cli.AwaiterModelControllerClient;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.ConnectionInfo;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.NodePathFormatter;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;

public class CommandExecutor {
    private static final String CANCEL_MSG = "Cancelling running operation...";
    private static final String TIMEOUT_CANCEL_MSG = "Timeout. Cancelling running operation...";
    private static final String CANCELED_MSG = "Command timeout, task has been canceled";
    private final CommandContext ctx;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thr = new Thread(r, "CLI command executor");
            thr.setDaemon(true);
            return thr;
        }
    });
    private Future<?> handlerTask;

    public CommandExecutor(CommandContext ctx) {
        this.ctx = ctx;
    }

    ModelNode execute(Operation op, int timeout, TimeUnit unit) throws CommandLineException, InterruptedException, ExecutionException, TimeoutException, IOException {
        ModelControllerClient client = this.ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandLineException("CLI not connected");
        }
        CompletableFuture<ModelNode> task = client.executeAsync(op, OperationMessageHandler.DISCARD);
        try {
            if (timeout <= 0) {
                return (ModelNode)task.get();
            }
            try {
                return (ModelNode)task.get(timeout, unit);
            }
            catch (TimeoutException ex) {
                CommandExecutor.cancelTask(task, this.ctx, CANCEL_MSG);
                throw ex;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            CommandExecutor.cancelTask(task, this.ctx, CANCEL_MSG);
            throw ex;
        }
    }

    public void execute(final CommandHandler handler, int timeout, TimeUnit unit) throws CommandLineException, InterruptedException, ExecutionException, TimeoutException {
        ExecutableBuilder builder = new ExecutableBuilder(){
            CommandContext c;
            {
                this.c = CommandExecutor.this.newTimeoutCommandContext(CommandExecutor.this.ctx);
            }

            @Override
            public Executable build() {
                return () -> handler.handle(this.c);
            }

            @Override
            public CommandContext getCommandContext() {
                return this.c;
            }
        };
        this.execute(builder, timeout, unit);
    }

    void execute(ExecutableBuilder builder, int timeout, TimeUnit unit) throws CommandLineException, InterruptedException, ExecutionException, TimeoutException {
        block7: {
            Future<Void> task = this.executorService.submit(() -> {
                builder.build().execute();
                return null;
            });
            try {
                if (timeout <= 0) {
                    task.get();
                    break block7;
                }
                try {
                    task.get(timeout, unit);
                }
                catch (TimeoutException ex) {
                    CommandContext c = builder.getCommandContext();
                    if (c instanceof TimeoutCommandContext) {
                        ((TimeoutCommandContext)c).timeout();
                    }
                    task.cancel(true);
                    throw ex;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                CommandExecutor.cancelTask(task, builder.getCommandContext(), null);
                CommandContext c = builder.getCommandContext();
                if (c instanceof TimeoutCommandContext) {
                    ((TimeoutCommandContext)c).interrupted();
                }
                throw ex;
            }
        }
    }

    private static boolean cancelTask(Future<?> task, CommandContext ctx, String msg) {
        if (!(task == null || task.isDone() && task.isCancelled())) {
            try {
                if (msg != null) {
                    ctx.printLine(msg);
                }
                task.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    void cancel() {
        this.executorService.shutdownNow();
    }

    CommandContext newTimeoutCommandContext(CommandContext ctx) {
        if (ctx.getCommandTimeout() <= 0) {
            return ctx;
        }
        return new TimeoutCommandContext(ctx);
    }

    public Future<?> getLastTask() {
        return this.handlerTask;
    }

    public static interface ExecutableBuilder {
        public Executable build();

        public CommandContext getCommandContext();
    }

    public class TimeoutCommandContext
    implements CommandContext {
        private final CommandContext wrapped;
        private final ModelControllerClient client;
        private Future<?> handlerTask;
        private boolean timeout;

        TimeoutCommandContext(CommandContext wrapped) {
            this.wrapped = wrapped;
            this.client = wrapped.getModelControllerClient() == null ? null : new TimeoutModelControllerClient(wrapped.getModelControllerClient());
        }

        synchronized void timeout() {
            this.timeout = true;
            CommandExecutor.cancelTask(this.handlerTask, this.wrapped, CommandExecutor.TIMEOUT_CANCEL_MSG);
        }

        synchronized void interrupted() {
            CommandExecutor.cancelTask(this.handlerTask, this.wrapped, CommandExecutor.CANCEL_MSG);
        }

        public synchronized boolean setLastHandlerTask(Future<?> handlerTask) {
            boolean ret = false;
            if (this.timeout) {
                ret = CommandExecutor.cancelTask(handlerTask, this.wrapped, CommandExecutor.CANCEL_MSG);
            } else {
                this.handlerTask = handlerTask;
            }
            return ret;
        }

        public Future<?> getLastTask() {
            return this.handlerTask;
        }

        @Override
        public CliConfig getConfig() {
            return this.wrapped.getConfig();
        }

        @Override
        public String getArgumentsString() {
            return this.wrapped.getArgumentsString();
        }

        @Override
        public ParsedCommandLine getParsedCommandLine() {
            return this.wrapped.getParsedCommandLine();
        }

        @Override
        public void printLine(String message) {
            this.wrapped.printLine(message);
        }

        @Override
        public void printColumns(Collection<String> col) {
            this.wrapped.printColumns(col);
        }

        @Override
        public void clearScreen() {
            this.wrapped.clearScreen();
        }

        @Override
        public void terminateSession() {
            this.wrapped.terminateSession();
        }

        @Override
        public boolean isTerminated() {
            return this.wrapped.isTerminated();
        }

        @Override
        public void set(CommandContext.Scope scope, String key, Object value) {
            this.wrapped.set(scope, key, value);
        }

        @Override
        public Object get(CommandContext.Scope scope, String key) {
            return this.wrapped.get(scope, key);
        }

        @Override
        public void clear(CommandContext.Scope scope) {
            this.wrapped.clear(scope);
        }

        @Override
        public Object remove(CommandContext.Scope scope, String key) {
            return this.wrapped.remove(scope, key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public void connectController() throws CommandLineException {
            this.wrapped.connectController();
        }

        @Override
        public void connectController(String controller, String client) throws CommandLineException {
            this.wrapped.connectController(controller, client);
        }

        @Override
        public void connectController(String controller) throws CommandLineException {
            this.wrapped.connectController(controller);
        }

        @Override
        public void connectController(String host, int port) throws CommandLineException {
            this.wrapped.connectController(host, port);
        }

        @Override
        public void bindClient(ModelControllerClient newClient) {
            this.wrapped.bindClient(newClient);
        }

        @Override
        public void disconnectController() {
            this.wrapped.disconnectController();
        }

        @Override
        public String getDefaultControllerHost() {
            return this.wrapped.getDefaultControllerHost();
        }

        @Override
        public int getDefaultControllerPort() {
            return this.wrapped.getDefaultControllerPort();
        }

        @Override
        public ControllerAddress getDefaultControllerAddress() {
            return this.wrapped.getDefaultControllerAddress();
        }

        @Override
        public String getControllerHost() {
            return this.wrapped.getControllerHost();
        }

        @Override
        public int getControllerPort() {
            return this.wrapped.getControllerPort();
        }

        @Override
        public CommandLineParser getCommandLineParser() {
            return this.wrapped.getCommandLineParser();
        }

        @Override
        public OperationRequestAddress getCurrentNodePath() {
            return this.wrapped.getCurrentNodePath();
        }

        @Override
        public NodePathFormatter getNodePathFormatter() {
            return this.wrapped.getNodePathFormatter();
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.wrapped.getOperationCandidatesProvider();
        }

        @Override
        public CommandHistory getHistory() {
            return this.wrapped.getHistory();
        }

        @Override
        public boolean isBatchMode() {
            return this.wrapped.isBatchMode();
        }

        @Override
        public boolean isWorkflowMode() {
            return this.wrapped.isWorkflowMode();
        }

        @Override
        public BatchManager getBatchManager() {
            return this.wrapped.getBatchManager();
        }

        @Override
        public BatchedCommand toBatchedCommand(String line) throws CommandFormatException {
            return this.wrapped.toBatchedCommand(line);
        }

        @Override
        public ModelNode buildRequest(String line) throws CommandFormatException {
            return this.wrapped.buildRequest(line);
        }

        @Override
        public CommandLineCompleter getDefaultCommandCompleter() {
            return this.wrapped.getDefaultCommandCompleter();
        }

        @Override
        public boolean isDomainMode() {
            return this.wrapped.isDomainMode();
        }

        @Override
        public void addEventListener(CliEventListener listener) {
            this.wrapped.addEventListener(listener);
        }

        @Override
        public int getExitCode() {
            return this.wrapped.getExitCode();
        }

        @Override
        public void handle(String line) throws CommandLineException {
            this.wrapped.handle(line);
        }

        @Override
        public void handleSafe(String line) {
            this.wrapped.handleSafe(line);
        }

        @Override
        public void interact() {
            this.wrapped.interact();
        }

        @Override
        public File getCurrentDir() {
            return this.wrapped.getCurrentDir();
        }

        @Override
        public void setCurrentDir(File dir) {
            this.wrapped.setCurrentDir(dir);
        }

        @Override
        public boolean isResolveParameterValues() {
            return this.wrapped.isResolveParameterValues();
        }

        @Override
        public void setResolveParameterValues(boolean resolve) {
            this.wrapped.setResolveParameterValues(resolve);
        }

        @Override
        public boolean isSilent() {
            return this.wrapped.isSilent();
        }

        @Override
        public void setSilent(boolean silent) {
            this.wrapped.setSilent(silent);
        }

        @Override
        public int getTerminalWidth() {
            return this.wrapped.getTerminalWidth();
        }

        @Override
        public int getTerminalHeight() {
            return this.wrapped.getTerminalHeight();
        }

        @Override
        public void setVariable(String name, String value) throws CommandLineException {
            this.wrapped.setVariable(name, value);
        }

        @Override
        public String getVariable(String name) {
            return this.wrapped.getVariable(name);
        }

        @Override
        public Collection<String> getVariables() {
            return this.wrapped.getVariables();
        }

        @Override
        public void registerRedirection(CommandLineRedirection redirection) throws CommandLineException {
            this.wrapped.registerRedirection(redirection);
        }

        @Override
        public ConnectionInfo getConnectionInfo() {
            return this.wrapped.getConnectionInfo();
        }

        @Override
        public void captureOutput(PrintStream captor) {
            this.wrapped.captureOutput(captor);
        }

        @Override
        public void releaseOutput() {
            this.wrapped.releaseOutput();
        }

        @Override
        public void setCommandTimeout(int numSeconds) {
            this.wrapped.setCommandTimeout(numSeconds);
        }

        @Override
        public int getCommandTimeout() {
            return this.wrapped.getCommandTimeout();
        }

        @Override
        public void resetTimeout(CommandContext.TIMEOUT_RESET_VALUE value) {
            this.wrapped.resetTimeout(value);
        }

        @Override
        public ModelNode execute(ModelNode mn, String description) throws CommandLineException, IOException {
            return this.wrapped.execute(mn, description);
        }

        @Override
        public ModelNode execute(Operation op, String description) throws CommandLineException, IOException {
            return this.wrapped.execute(op, description);
        }

        private class TimeoutModelControllerClient
        implements ModelControllerClient,
        AwaiterModelControllerClient {
            private final ModelControllerClient wrapped;

            TimeoutModelControllerClient(ModelControllerClient wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
                return this.doExecute(operation, messageHandler);
            }

            @Override
            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return this.doExecute(operation, messageHandler);
            }

            @Override
            public ModelNode execute(ModelNode operation) throws IOException {
                return this.doExecute(operation);
            }

            @Override
            public ModelNode execute(Operation operation) throws IOException {
                return this.doExecute(operation);
            }

            @Override
            public CompletableFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.doExecuteAsync(operation, messageHandler);
            }

            @Override
            public CompletableFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.doExecuteAsync(operation, messageHandler);
            }

            @Override
            public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return this.doExecuteOperation(operation, messageHandler);
            }

            @Override
            public CompletableFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.doExecuteOperationAsync(operation, messageHandler);
            }

            @Override
            public ModelNode execute(ModelNode operation, boolean awaitClose) throws IOException {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new IOException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                ModelNode response = this.execute(operation);
                if (!Util.isSuccess(response)) {
                    return response;
                }
                ((AwaiterModelControllerClient)((Object)this.wrapped)).awaitClose(awaitClose);
                return response;
            }

            @Override
            public void awaitClose(boolean awaitClose) throws IOException {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new IOException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                ((AwaiterModelControllerClient)((Object)this.wrapped)).awaitClose(awaitClose);
            }

            @Override
            public boolean isConnected() {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new RuntimeException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                return ((AwaiterModelControllerClient)((Object)this.wrapped)).isConnected();
            }

            @Override
            public void ensureConnected(long timeoutMillis) throws CommandLineException, IOException {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new CommandLineException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                ((AwaiterModelControllerClient)((Object)this.wrapped)).ensureConnected(timeoutMillis);
            }

            private CompletableFuture<OperationResponse> doExecuteOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                CompletableFuture<OperationResponse> task = this.wrapped.executeOperationAsync(operation, messageHandler);
                TimeoutCommandContext.this.setLastHandlerTask(task);
                return task;
            }

            private OperationResponse doExecuteOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                CompletableFuture<OperationResponse> task = this.wrapped.executeOperationAsync(operation, messageHandler);
                boolean canceled = TimeoutCommandContext.this.setLastHandlerTask(task);
                if (canceled) {
                    throw new CancellationException(CommandExecutor.CANCELED_MSG);
                }
                try {
                    return task.get();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
            }

            private CompletableFuture<ModelNode> doExecuteAsync(Operation operation, OperationMessageHandler messageHandler) {
                CompletableFuture<ModelNode> task = this.wrapped.executeAsync(operation, messageHandler);
                TimeoutCommandContext.this.setLastHandlerTask(task);
                return task;
            }

            private CompletableFuture<ModelNode> doExecuteAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                CompletableFuture<ModelNode> task = this.wrapped.executeAsync(operation, messageHandler);
                TimeoutCommandContext.this.setLastHandlerTask(task);
                return task;
            }

            private ModelNode doExecute(Operation operation) throws IOException {
                try {
                    CompletableFuture<ModelNode> task = this.wrapped.executeAsync(operation, OperationMessageHandler.DISCARD);
                    boolean canceled = TimeoutCommandContext.this.setLastHandlerTask(task);
                    if (canceled) {
                        throw new CancellationException(CommandExecutor.CANCELED_MSG);
                    }
                    return (ModelNode)task.get();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }

            private ModelNode doExecute(ModelNode operation) throws IOException {
                try {
                    CompletableFuture<ModelNode> task = this.wrapped.executeAsync(operation, OperationMessageHandler.DISCARD);
                    boolean canceled = TimeoutCommandContext.this.setLastHandlerTask(task);
                    if (canceled) {
                        throw new CancellationException(CommandExecutor.CANCELED_MSG);
                    }
                    return (ModelNode)task.get();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }

            private ModelNode doExecute(ModelNode operation, OperationMessageHandler handler) throws IOException {
                try {
                    CompletableFuture<ModelNode> task = this.wrapped.executeAsync(operation, handler);
                    boolean canceled = TimeoutCommandContext.this.setLastHandlerTask(task);
                    if (canceled) {
                        throw new CancellationException(CommandExecutor.CANCELED_MSG);
                    }
                    return (ModelNode)task.get();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }

            private ModelNode doExecute(Operation operation, OperationMessageHandler handler) throws IOException {
                try {
                    CompletableFuture<ModelNode> task = this.wrapped.executeAsync(operation, handler);
                    boolean canceled = TimeoutCommandContext.this.setLastHandlerTask(task);
                    if (canceled) {
                        throw new CancellationException(CommandExecutor.CANCELED_MSG);
                    }
                    return (ModelNode)task.get();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }

            @Override
            public void close() throws IOException {
                this.wrapped.close();
            }
        }
    }

    public static interface Executable {
        public void execute() throws CommandLineException;
    }
}

