/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.KnnPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.KnnPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.KnnPredicateVectorStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.KnnPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;

public class KnnPredicateFieldStepImpl
extends AbstractPredicateFinalStep
implements KnnPredicateFieldStep,
KnnPredicateVectorStep,
KnnPredicateOptionsStep {
    private final SearchPredicateFactory factory;
    private final int k;
    private BooleanPredicateBuilder booleanBuilder;
    protected KnnPredicateBuilder builder;

    public KnnPredicateFieldStepImpl(SearchPredicateFactory factory, SearchPredicateDslContext<?> dslContext, int k) {
        super(dslContext);
        this.factory = factory;
        this.k = k;
    }

    @Override
    public KnnPredicateVectorStep field(String fieldPath) {
        this.builder = this.dslContext.scope().fieldQueryElement(fieldPath, PredicateTypeKeys.KNN);
        this.builder.k(this.k);
        return this;
    }

    @Override
    protected SearchPredicate build() {
        if (this.booleanBuilder != null) {
            this.builder.filter(this.booleanBuilder.build());
        }
        return this.builder.build();
    }

    @Override
    public KnnPredicateOptionsStep filter(SearchPredicate searchPredicate) {
        this.booleanPredicateBuilder().must(searchPredicate);
        return this;
    }

    @Override
    public KnnPredicateOptionsStep filter(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> clauseContributor) {
        this.booleanPredicateBuilder().must(clauseContributor.apply(this.factory).toPredicate());
        return this;
    }

    @Override
    public KnnPredicateOptionsStep matching(byte ... vector) {
        this.builder.vector(vector);
        return this;
    }

    @Override
    public KnnPredicateOptionsStep matching(float ... vector) {
        this.builder.vector(vector);
        return this;
    }

    @Override
    public KnnPredicateOptionsStep requiredMinimumSimilarity(float similarity) {
        this.builder.requiredMinimumSimilarity(similarity);
        return this;
    }

    @Override
    public KnnPredicateOptionsStep requiredMinimumScore(float score) {
        this.builder.requiredMinimumScore(score);
        return this;
    }

    @Override
    public KnnPredicateOptionsStep boost(float boost) {
        this.builder.boost(boost);
        return this;
    }

    @Override
    public KnnPredicateOptionsStep constantScore() {
        this.builder.constantScore();
        return this;
    }

    private BooleanPredicateBuilder booleanPredicateBuilder() {
        if (this.booleanBuilder == null) {
            this.booleanBuilder = this.dslContext.scope().predicateBuilders().bool();
        }
        return this.booleanBuilder;
    }
}

