/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.caffeine;

import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Weigher;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import org.wildfly.clustering.cache.caffeine.CacheFactory;
import org.wildfly.clustering.function.BiPredicate;

public interface CacheConfiguration<K, V> {
    public OptionalLong getMaxWeight();

    public Expiry<K, V> getExpiry();

    public Weigher<K, V> getWeigher();

    public Optional<RemovalListener<K, V>> getEvictionListener();

    public Optional<RemovalListener<K, V>> getRemovalListener();

    public Scheduler getScheduler();

    public static <K, V> Builder<K, V> builder() {
        return new Builder<K, V>(){
            private OptionalLong maxWeight = OptionalLong.empty();
            private Expiry<K, V> expiry = CacheFactory.never();
            private Weigher<K, V> weigher = Weigher.singletonWeigher();
            private Optional<RemovalListener<K, V>> evictionListener = Optional.empty();
            private Optional<RemovalListener<K, V>> removalListener = Optional.empty();
            private Scheduler scheduler = Scheduler.systemScheduler();

            @Override
            public Builder<K, V> withMaxWeight(long weight) {
                this.maxWeight = OptionalLong.of(weight);
                return this;
            }

            @Override
            public Builder<K, V> withWeigher(Weigher<K, V> weigher) {
                this.weigher = weigher;
                return this;
            }

            @Override
            public Builder<K, V> withExpiry(Expiry<K, V> expiry) {
                this.expiry = expiry;
                return this;
            }

            @Override
            public Builder<K, V> whenEvicted(RemovalListener<K, V> listener) {
                this.evictionListener = Optional.of(listener);
                return this;
            }

            @Override
            public Builder<K, V> whenRemoved(RemovalListener<K, V> listener) {
                this.removalListener = Optional.of(listener);
                return this;
            }

            @Override
            public Builder<K, V> withScheduler(Scheduler scheduler) {
                this.scheduler = scheduler;
                return this;
            }

            @Override
            public CacheConfiguration<K, V> build() {
                final OptionalLong maxWeight = this.maxWeight;
                final Expiry expiry = this.expiry;
                final Weigher weigher = this.weigher;
                final Optional evictionListener = this.evictionListener;
                final Optional removalListener = this.removalListener;
                final Scheduler scheduler = this.scheduler;
                return new CacheConfiguration<K, V>(){

                    @Override
                    public OptionalLong getMaxWeight() {
                        return maxWeight;
                    }

                    @Override
                    public Expiry<K, V> getExpiry() {
                        return expiry;
                    }

                    @Override
                    public Weigher<K, V> getWeigher() {
                        return weigher;
                    }

                    @Override
                    public Optional<RemovalListener<K, V>> getEvictionListener() {
                        return evictionListener;
                    }

                    @Override
                    public Optional<RemovalListener<K, V>> getRemovalListener() {
                        return removalListener;
                    }

                    @Override
                    public Scheduler getScheduler() {
                        return scheduler;
                    }
                };
            }
        };
    }

    public static interface Builder<K, V> {
        public Builder<K, V> withMaxWeight(long var1);

        default public Builder<K, V> evictableWhen(Predicate<K> evictable) {
            return this.evictableWhen((java.util.function.BiPredicate<K, V>)(evictable != org.wildfly.clustering.function.Predicate.always() ? BiPredicate.testFormer(evictable) : BiPredicate.always()));
        }

        default public Builder<K, V> evictableWhen(final java.util.function.BiPredicate<K, V> evictable) {
            return this.withWeigher((Weigher<K, V>)(evictable != BiPredicate.always() ? new Weigher<K, V>(){

                public int weigh(K key, V value) {
                    return evictable.test(key, value) ? 1 : 0;
                }
            } : Weigher.singletonWeigher()));
        }

        default public Builder<K, V> withWeight(ToIntBiFunction<K, V> weight) {
            Weigher weigher = weight::applyAsInt;
            return this.withWeigher(weigher);
        }

        public Builder<K, V> withWeigher(Weigher<K, V> var1);

        default public Builder<K, V> evictAfter(Duration idleTimeout) {
            return idleTimeout != null ? this.evictAfter((Function<V, Duration>)org.wildfly.clustering.function.Function.of((Object)idleTimeout)) : this.withExpiry(CacheFactory.never());
        }

        default public Builder<K, V> evictAfter(Function<V, Duration> idleTimeout) {
            return this.evictAfter((BiFunction<K, V, Duration>)org.wildfly.clustering.function.BiFunction.applyLatter(idleTimeout));
        }

        default public Builder<K, V> evictAfter(final BiFunction<K, V, Duration> idleTimeout) {
            return this.withExpiry(new Expiry<K, V>(){

                public long expireAfterCreate(K key, V value, long currentTime) {
                    return ((Duration)idleTimeout.apply(key, value)).toNanos();
                }

                public long expireAfterUpdate(K key, V value, long currentTime, long currentDuration) {
                    return ((Duration)idleTimeout.apply(key, value)).toNanos();
                }

                public long expireAfterRead(K key, V value, long currentTime, long currentDuration) {
                    return ((Duration)idleTimeout.apply(key, value)).toNanos();
                }
            });
        }

        public Builder<K, V> withExpiry(Expiry<K, V> var1);

        default public Builder<K, V> whenEvicted(final BiConsumer<K, V> handler) {
            return this.whenEvicted(new RemovalListener<K, V>(){

                public void onRemoval(K key, V value, RemovalCause cause) {
                    if (cause == RemovalCause.EXPIRED || cause == RemovalCause.SIZE) {
                        handler.accept(key, value);
                    }
                }
            });
        }

        public Builder<K, V> whenEvicted(RemovalListener<K, V> var1);

        default public Builder<K, V> whenRemoved(final BiConsumer<K, V> handler) {
            return this.whenRemoved(new RemovalListener<K, V>(){

                public void onRemoval(K key, V value, RemovalCause cause) {
                    if (cause == RemovalCause.EXPIRED || cause == RemovalCause.SIZE) {
                        handler.accept(key, value);
                    }
                }
            });
        }

        public Builder<K, V> whenRemoved(RemovalListener<K, V> var1);

        default public Builder<K, V> withExecutor(ScheduledExecutorService executor) {
            return this.withScheduler(executor != null ? Scheduler.forScheduledExecutorService((ScheduledExecutorService)executor) : Scheduler.systemScheduler());
        }

        public Builder<K, V> withScheduler(Scheduler var1);

        public CacheConfiguration<K, V> build();
    }
}

