/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.util.Objects;

public class ContentRepositoryElement {
    private final String path;
    private final boolean folder;
    private final long size;

    private ContentRepositoryElement(String path, boolean folder, long size) {
        this.path = path;
        this.folder = folder;
        this.size = size;
    }

    public static ContentRepositoryElement createFolder(String path) {
        return new ContentRepositoryElement(path, true, -1L);
    }

    public static ContentRepositoryElement createFile(String path, long size) {
        return new ContentRepositoryElement(path, false, size);
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.path);
        hash = 97 * hash + (this.folder ? 1 : 0);
        hash = 97 * hash + (int)(this.size ^ this.size >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentRepositoryElement other = (ContentRepositoryElement)obj;
        if (this.folder != other.folder) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    public String toString() {
        return "ContentRepositoryElement{path=" + this.path + ", folder=" + this.folder + ", size=" + this.size + "}";
    }
}

